package ru.yandex.chemodan.app.dataapi.api.deltas;

import org.junit.Test;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.function.Function2;
import ru.yandex.chemodan.app.dataapi.api.data.record.DataRecord;
import ru.yandex.chemodan.app.dataapi.api.data.record.DataRecordId;
import ru.yandex.chemodan.app.dataapi.api.db.handle.DatabaseHandle;
import ru.yandex.chemodan.app.dataapi.api.db.ref.AppDatabaseRef;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.misc.test.Assert;

/**
 * @author tolmalev
 */
public class DeltaUtilsTest {
    @Test
    public void findNonExistingRecordDeletionOrUpdate() {
        AppDatabaseRef dbRef = new AppDatabaseRef("app", "ref");
        DatabaseHandle dbHandle = dbRef.consHandle("db");

        DataRecordId rec1Id = new DataRecordId(dbHandle, "coll", "rec1");
        DataRecordId rec2Id = new DataRecordId(dbHandle, "coll", "rec2");

        Function2<ListF<DataRecord>, ListF<Delta>, Option<DataRecordId>> findF =
                (rs, ds) -> DeltaUtils.findNonExistingRecordDeletionOrUpdate(dbHandle, rs, ds)
                        .map(change -> change.getRecordId(dbHandle));

        ListF<DataRecord> records;
        ListF<Delta> deltas;

        records = Cf.list();
        deltas = Cf.list(new Delta(createEmptyChange(rec1Id, RecordChangeType.INSERT)));
        Assert.none(findF.apply(records, deltas));

        records = Cf.list(createEmptyRecord(rec1Id));
        deltas = Cf.list(new Delta(createEmptyChange(rec1Id, RecordChangeType.INSERT)));
        Assert.none(findF.apply(records, deltas));

        records = Cf.list(createEmptyRecord(rec1Id));
        deltas = Cf.list(new Delta(createEmptyChange(rec1Id, RecordChangeType.DELETE)));
        Assert.none(findF.apply(records, deltas));

        records = Cf.list();
        deltas = Cf.list(new Delta(createEmptyChange(rec1Id, RecordChangeType.DELETE)));
        Assert.some(rec1Id, findF.apply(records, deltas));

        records = Cf.list();
        deltas = Cf.list(
                new Delta(createEmptyChange(rec1Id, RecordChangeType.INSERT)),
                new Delta(createEmptyChange(rec1Id, RecordChangeType.DELETE)),
                new Delta(createEmptyChange(rec1Id, RecordChangeType.INSERT)));
        Assert.none(findF.apply(records, deltas));

        records = Cf.list(createEmptyRecord(rec1Id));
        deltas = Cf.list(
                new Delta(createEmptyChange(rec1Id, RecordChangeType.SET)),
                new Delta(Cf.list(
                        createEmptyChange(rec1Id, RecordChangeType.UPDATE),
                        createEmptyChange(rec2Id, RecordChangeType.UPDATE))));
        Assert.some(rec2Id, findF.apply(records, deltas));
    }

    public static DataRecord createEmptyRecord(DataRecordId recId) {
        return new DataRecord(DataApiUserId.parse("1"), recId, 0, Cf.map());
    }

    public static RecordChange createEmptyChange(DataRecordId recId, RecordChangeType type) {
        switch (type) {
            case INSERT: return RecordChange.insertEmpty(recId);
            case DELETE: return RecordChange.delete(recId);
            case UPDATE: return RecordChange.update(recId, Cf.list());
            case SET: return RecordChange.set(recId.collectionId(), recId.recordId(), Cf.map());
        }
        throw new AssertionError("Unknown change type: " + type);
    }
}
