package ru.yandex.chemodan.app.dataapi.api.deltas;

import java.util.Collection;
import java.util.Map;

import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.function.Function1B;
import ru.yandex.misc.annotation.Nullable;
import ru.yandex.misc.lang.Assume;

/**
 * @author tolmalev
 */
public class DeltaValidate extends org.apache.commons.lang3.Validate {

    public static final DeltaValidateImpl DV = new DeltaValidateImpl();

    public static class DeltaValidateImpl extends Assume {
        public void fail(String message) {
            throw new DeltaValidationException(message);
        }
    }

    // autogenerated delegates, do not edit

    public static void fail() {
        DV.fail();
    }

    public static void isTrue(boolean cond) {
        DV.isTrue(cond);
    }

    public static void isTrue(boolean cond, String message) {
        DV.isTrue(cond, message);
    }

    public static void isTrue(boolean cond, String message, Object param) {
        DV.isTrue(cond, message, param);
    }

    public static void isTrue(String message, boolean cond) {
        DV.isTrue(message, cond);
    }

    public static void isFalse(boolean cond) {
        DV.isFalse(cond);
    }

    public static void isFalse(boolean cond, String message) {
        DV.isFalse(cond, message);
    }

    public static void isFalse(boolean cond, String message, Object param) {
        DV.isFalse(cond, message, param);
    }

    public static Object notNull(@Nullable Object o) {
        DV.notNull(o);
        return o;
    }

    public static void notNull(@Nullable Object o, String param) {
        DV.notNull(o, param);
    }

    public static void isNull(@Nullable Object o) {
        DV.isNull(o);
    }

    public static CharSequence notEmpty(CharSequence cs) {
        DV.notEmpty(cs);
        return cs;
    }

    public static void notEmpty(CharSequence cs, String message) {
        DV.notEmpty(cs, message);
    }

    public static void notBlank(String cs) {
        DV.notBlank(cs);
    }

    public static void notBlank(String cs, String message) {
        DV.notBlank(cs, message);
    }

    public static Collection notEmpty(Collection collection) {
        DV.notEmpty(collection);
        return collection;
    }

    public static void notEmpty(Collection collection, String message) {
        DV.notEmpty(collection, message);
    }

    public static <A extends Comparable<A>, B extends A> void lt(Comparable<A> a, Comparable<B> b) {
        DV.lt(a, b);
    }

    public static <A extends Comparable<A>, B extends A> void le(Comparable<A> a, Comparable<B> b) {
        DV.le(a, b);
    }

    public static <A extends Comparable<A>, B extends A> void gt(Comparable<A> a, Comparable<B> b) {
        DV.gt(a, b);
    }

    public static <A extends Comparable<A>, B extends A> void ge(Comparable<A> a, Comparable<B> b) {
        DV.ge(a, b);
    }

    public static <A extends Comparable<A>, B extends A> void lt(Comparable<A> a, Comparable<B> b,
            String message)
    {
        DV.lt(a, b, message);
    }

    public static <A extends Comparable<A>, B extends A> void le(Comparable<A> a, Comparable<B> b,
            String message)
    {
        DV.le(a, b, message);
    }

    public static <A extends Comparable<A>, B extends A> void gt(Comparable<A> a, Comparable<B> b,
            String message)
    {
        DV.gt(a, b, message);
    }

    public static <A extends Comparable<A>, B extends A> void ge(Comparable<A> a, Comparable<B> b,
            String message)
    {
        DV.ge(a, b, message);
    }

    public static void sizeIs(int expected, Collection<?> collection) {
        DV.sizeIs(expected, collection);
    }

    public static void sizeIs(int expected, Map<?, ?> map) {
        DV.sizeIs(expected, map);
    }

    public static <T> void exists(Collection<T> list, Function1B<T> p) {
        DV.exists(list, p);
    }

    public static void none(Option<?> option) {
        DV.none(option);
    }

    public static void none(Option<?> option, String message) {
        DV.none(option, message);
    }

    public static void some(Option<?> option) {
        DV.some(option);
    }

    public static void some(Option<?> option, String message) {
        DV.some(option, message);
    }

    public static <T> void some(T value, Option<T> option) {
        DV.some(value, option);
    }

    public static void hasSize(int expectedSize, Object collection) {
        DV.hasSize(expectedSize, collection);
    }

    public static void hasSize(int expectedSize, Object collection, String message) {
        DV.hasSize(expectedSize, collection, message);
    }

    public static void sameSize(Object expectedCollection, Object collection) {
        DV.sameSize(expectedCollection, collection);
    }

    public static void sameSize(Object expectedCollection, Object collection, String message) {
        DV.sameSize(expectedCollection, collection, message);
    }

    public static void isEmpty(Object collection) {
        DV.isEmpty(collection);
    }

    public static void isEmpty(Object collection, String message) {
        DV.isEmpty(collection, message);
    }

    public static <T> void contained(T element, Collection<T> collection) {
        DV.contained(element, collection);
    }

    public static <T> void in(T element, Collection<T> collection) {
        DV.in(element, collection);
    }

    public static <T> void notIn(T element, Collection<T> collection) {
        DV.notIn(element, collection);
    }

    public static <T> void forAll(Collection<T> collection,
            Function1B<? super T> func)
    {
        DV.forAll(collection, func);
    }

    public static void hasNoNulls(Collection<?> collection) {
        DV.hasNoNulls(collection);
    }

    public static void unique(Collection<?> collection) {
        DV.unique(collection);
    }

    public static void unique(Collection<?> collection, String message) {
        DV.unique(collection, message);
    }

    public static <B, A extends B> void equals(A a, B b) {
        DV.equals(a, b);
    }

    public static void equals(float a, float b, float eps) {
        DV.equals(a, b, eps);
    }

    public static void equals(double a, double b, double eps) {
        DV.equals(a, b, eps);
    }

    public static void equalsTu(Object a, Object b) {
        DV.equalsTu(a, b);
    }

    public static <B, A extends B> void equals(A a, B b, String message) {
        DV.equals(a, b, message);
    }

    public static void equalsTu(Object a, Object b, String message) {
        DV.equalsTu(a, b, message);
    }

    public static <B, A extends B> void notEquals(A a, B b) {
        DV.notEquals(a, b);
    }

    public static void notEqualsTu(Object a, Object b) {
        DV.notEqualsTu(a, b);
    }

    public static <B, A extends B> void reflectionEquals(A a, B b) {
        DV.reflectionEquals(a, b);
    }

    public static void reflectionEqualsTu(Object a, Object b) {
        DV.reflectionEqualsTu(a, b);
    }

    public static void arraysEquals(Object a, Object b) {
        DV.arraysEquals(a, b);
    }

    public static void holdsLock(Object lock) {
        DV.holdsLock(lock);
    }
}
