package ru.yandex.chemodan.app.dataapi.api.deltas;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.db.Database;
import ru.yandex.commune.a3.action.result.pojo.ActionResultPojo;
import ru.yandex.misc.bender.MembersToBind;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.bender.annotation.BenderIgnore;
import ru.yandex.misc.bender.annotation.BenderMembersToBind;
import ru.yandex.misc.bender.annotation.BenderPart;

/**
 * @author dbrylev
 */
@ActionResultPojo
@BenderMembersToBind(MembersToBind.WITH_ANNOTATIONS)
public class DeltasAppliedDatabase {

    public final Database database;
    public final ListF<Delta> deltas;

    @BenderPart
    private final ListF<Diff> diffs;

    @BenderIgnore
    final DatabaseChange event;

    public DeltasAppliedDatabase(ListF<Delta> deltas, DatabaseChange event) {
        this.database = event.patchedDatabase();
        this.deltas = deltas;
        this.diffs = deltas.map(Diff::new);
        this.event = event;
    }

    @BenderBindAllFields
    private static class Diff {
        public final Option<String> id;
        public final Option<Long> newRev;

        public Diff(Delta delta) {
            this.id = delta.id;
            this.newRev = delta.newRev;
        }
    }
}
