package ru.yandex.chemodan.app.dataapi.api.deltas;

import org.joda.time.Instant;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.Tuple2List;
import ru.yandex.chemodan.app.dataapi.api.db.handle.DatabaseHandle;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.chemodan.ratelimiter.chunk.ChunkRateLimiter;
import ru.yandex.commune.test.random.RunWithRandomTest;
import ru.yandex.misc.dataSize.DataSize;
import ru.yandex.misc.monica.core.name.MetricGroupName;

/**
 * @author tolmalev
 */
public interface DeltasJdbcDao {
    @RunWithRandomTest
    ListF<Delta> findAfterRevision(DataApiUserId uid, DatabaseHandle handle, long rev, int limit);

    @RunWithRandomTest
    Option<Long> findRevisionAfterTime(DataApiUserId uid, String handle, Instant instant, long minRevision);

    @RunWithRandomTest
    Option<Delta> find(DataApiUserId uid, DatabaseHandle handle, long rev);

    @RunWithRandomTest
    void insert(DataApiUserId uid, String datastoreHandle, Delta delta);

    void insertBatch(DataApiUserId uid, Tuple2List<String, Delta> handlesDeltas);

    @RunWithRandomTest
    DataSize findDeltasSize(DataApiUserId uid, String datastoreHandle, long fromRev);

    @RunWithRandomTest
    DataSize findDeltasSize(DataApiUserId uid, String datastoreHandle);

    void delete(DataApiUserId uid, String datastoreHandle, long rev);

    void deleteBatch(DataApiUserId uid, String datastoreHandle, ListF<Long> revs);

    void deleteBeforeRevision(DataApiUserId uid, String datastoreHandle, long rev);

    void deleteBeforeRevision(DataApiUserId uid, String datastoreHandle, long rev, ChunkRateLimiter rateLimiter);

    void deleteAllForDatabases(DataApiUserId uid, ListF<String> handles);

    void deleteAllForDatabases(DataApiUserId uid, ListF<String> handles, ChunkRateLimiter rateLimiter);

    MetricGroupName groupName(String s);
}
