package ru.yandex.chemodan.app.dataapi.api.deltas;

import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.chemodan.app.dataapi.api.db.ref.GlobalDatabaseRef;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.chemodan.app.dataapi.core.dao.support.DataApiRandomValueGenerator;
import ru.yandex.chemodan.app.dataapi.core.dao.test.ActivateDataApiEmbeddedPg;
import ru.yandex.chemodan.app.dataapi.test.DataApiTestSupport;
import ru.yandex.misc.test.Assert;

/**
 * @author tolmalev
 */
@ActivateDataApiEmbeddedPg
public class DeltasJdbcDaoTest extends DataApiTestSupport {

    @Autowired
    private DeltasJdbcDao dao;

    private final DataApiRandomValueGenerator R = new DataApiRandomValueGenerator();

    @Test
    public void simple() {
        DataApiUserId user = createRandomCleanUserInDefaultShard();
        String handle = R.randomValue(String.class);

        for (int i = 0; i < 2; i++) {
            Delta delta = R.randomValue(Delta.class).withRev(i);
            dao.insert(user, handle, delta);
            Assert.some(delta, dao.find(user, new GlobalDatabaseRef("db").consHandle(handle), i));

            dao.delete(user, handle, i);
        }
    }
}
