package ru.yandex.chemodan.app.dataapi.api.deltas;

import ru.yandex.chemodan.app.dataapi.api.data.field.DataField;
import ru.yandex.chemodan.app.dataapi.api.data.field.DataFieldMarshallerUnmarshaller;
import ru.yandex.chemodan.util.bender.JsonFieldLevelUnmarshaller;
import ru.yandex.misc.bender.parse.BenderJsonNode;
import ru.yandex.misc.bender.parse.ParseResult;
import ru.yandex.misc.bender.parse.UnmarshallerContext;
import ru.yandex.misc.bender.serialize.BenderJsonWriter;
import ru.yandex.misc.bender.serialize.simpleType.SimpleTypeMarshallerSupport;

/**
 * @author tolmalev
 */
public class FieldChangeMarshallerUnmarshaller extends SimpleTypeMarshallerSupport
        implements JsonFieldLevelUnmarshaller
{

    private static final String OP = "op";
    private static final String FIELD = "field";
    private static final String INDEX = "index";
    private static final String LIST_MOVE_DEST_INDEX = "destIndex";
    private static final String VALUE = "value";

    private static final String PUT = "put";
    private static final String DELETE = "delete";
    private static final String DELETE_LIST_ITEM = "deleteListItem";
    private static final String SET_LIST_ITEM = "setListItem";
    private static final String INSERT_LIST_ITEM = "insertListItem";
    private static final String MOVE_LIST_ITEM = "moveListItem";

    private final DataFieldMarshallerUnmarshaller marshaller = new DataFieldMarshallerUnmarshaller();

    @Override
    public ParseResult<Object> parseJsonNode(BenderJsonNode json,
            UnmarshallerContext unmarshallerContext)
    {
        String op = json.getField(OP).getOrThrow("No operation").getValueAsString();
        String field = json.getField(FIELD).getOrThrow("No field id").getValueAsString();
        if (DELETE.equals(op)) {
            return ParseResult.<Object>result(FieldChange.delete(field));
        } else if (PUT.equals(op)) {
            DataField value = (DataField) marshaller
                .parseJsonNode(json.getField(VALUE).getOrThrow("No value"), null)
                .getOrThrow();
            return ParseResult.<Object>result(FieldChange.put(field, value));
        } else if (DELETE_LIST_ITEM.equals(op)) {
            int index = json.getField(INDEX).get().getNumberValueOrNull().intValue();
            return ParseResult.<Object>result(FieldChange.deleteListItem(field, index));
        } else if (SET_LIST_ITEM.equals(op)) {
            int index = json.getField(INDEX).get().getNumberValueOrNull().intValue();
            DataField value = (DataField) marshaller
                    .parseJsonNode(json.getField(VALUE).get(), null)
                    .getOrThrow();
            return ParseResult.<Object>result(FieldChange.putListItem(field, index, value));
        } else if (INSERT_LIST_ITEM.equals(op)) {
            int index = json.getField(INDEX).get().getNumberValueOrNull().intValue();
            DataField value = (DataField) marshaller
                    .parseJsonNode(json.getField(VALUE).get(), null)
                    .getOrThrow();
            return ParseResult.<Object>result(FieldChange.insertListItem(field, index, value));
        } else if (MOVE_LIST_ITEM.equals(op)) {
            int index = json.getField(INDEX).get().getNumberValueOrNull().intValue();
            int destIndex = json.getField(LIST_MOVE_DEST_INDEX).get().getNumberValueOrNull().intValue();
            return ParseResult.<Object>result(FieldChange.moveListItem(field, index, destIndex));
        } else {
            throw new IllegalArgumentException("Unknown operation " + op);
        }
    }

    @Override
    protected void writeJson(BenderJsonWriter json, Object o) {
        json.writeObjectStart();
        json.writeFieldName(FIELD);
        FieldChange change = (FieldChange) o;
        json.writeString(change.key);
        if (change.type == FieldChange.FieldChangeType.PUT) {
            json.writeFieldName(OP);
            json.writeString(PUT);

            json.writeFieldName(VALUE);
            marshaller.writeJsonToField(json, change.getValue(), null);
        } else if (change.type == FieldChange.FieldChangeType.DELETE) {
            json.writeFieldName(OP);
            json.writeString(DELETE);
        } else if (change.type == FieldChange.FieldChangeType.DELETE_LIST_ITEM) {
            json.writeFieldName(OP);
            json.writeString(DELETE_LIST_ITEM);

            json.writeFieldName(INDEX);
            json.writeNumber(change.listIndex.get());
        } else if (change.type == FieldChange.FieldChangeType.PUT_LIST_ITEM) {
            json.writeFieldName(OP);
            json.writeString(SET_LIST_ITEM);

            json.writeFieldName(INDEX);
            json.writeNumber(change.listIndex.get());

            json.writeFieldName(VALUE);
            marshaller.writeJsonToField(json, change.getValue(), null);
        } else if (change.type == FieldChange.FieldChangeType.INSERT_LIST_ITEM) {
            json.writeFieldName(OP);
            json.writeString(INSERT_LIST_ITEM);

            json.writeFieldName(INDEX);
            json.writeNumber(change.listIndex.get());

            json.writeFieldName(VALUE);
            marshaller.writeJsonToField(json, change.getValue(), null);
        } else if (change.type == FieldChange.FieldChangeType.MOVE_LIST_ITEM) {
            json.writeFieldName(OP);
            json.writeString(MOVE_LIST_ITEM);

            json.writeFieldName(INDEX);
            json.writeNumber(change.listIndex.get());

            json.writeFieldName(LIST_MOVE_DEST_INDEX);
            json.writeNumber(change.listMoveDestIndex.get());
        }
        json.writeObjectEnd();
    }


    @Override
    protected String toStringValueForXml(Object o) {
        throw new IllegalStateException("XML is not supported");
    }
}
