package ru.yandex.chemodan.app.dataapi.api.deltas;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.app.dataapi.api.data.record.DatabaseRecord;
import ru.yandex.chemodan.app.dataapi.api.db.revision.DatabaseRefRevisions;
import ru.yandex.chemodan.app.dataapi.api.db.revision.DatabaseRevision;
import ru.yandex.commune.a3.action.result.pojo.ActionResultPojo;
import ru.yandex.commune.protobuf5.annotation.ProtoField;
import ru.yandex.commune.protobuf5.annotation.ProtoMessage;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;

/**
 * @author dbrylev
 */
@ActionResultPojo
@BenderBindAllFields
@ProtoMessage
public class ModifiedRecordsPojo {
    @ProtoField(n = 1)
    public final ListF<DatabaseRecord> objects;
    @ProtoField(n = 2)
    public final ListF<DatabaseRevision> progressRevisions;
    @ProtoField(n = 3)
    public final boolean hasMore;

    private ModifiedRecordsPojo(
            ListF<DatabaseRecord> objects,
            ListF<DatabaseRevision> progressRevisions,
            boolean hasMore)
    {
        this.objects = objects;
        this.progressRevisions = progressRevisions;
        this.hasMore = hasMore;
    }

    public static ModifiedRecordsPojo consFromRecordsSinceRevisions(
            ListF<DatabaseRecord> records,
            DatabaseRefRevisions sinceRevisions,
            boolean hasMore)
    {
        return new ModifiedRecordsPojo(
                records,
                sinceRevisions.withLatestFrom(records),
                hasMore
        );
    }
}
