package ru.yandex.chemodan.app.dataapi.api.deltas;

import ru.yandex.chemodan.app.dataapi.ErrorNames;
import ru.yandex.chemodan.app.dataapi.utils.HttpStatusCodeSourceWithErrorLevel;
import ru.yandex.commune.a3.action.A3Exception;
import ru.yandex.misc.io.http.HttpStatus;

/**
 * @author tolmalev
 */
public class OutdatedChangeException extends A3Exception implements HttpStatusCodeSourceWithErrorLevel {

    public OutdatedChangeException(long currentRev, long requestRev) {
        super(ErrorNames.OUTDATED_CHANGE, "Current rev: " + currentRev + ", request rev: " + requestRev);
    }

    public OutdatedChangeException(String record, long currentRev, long requestRev) {
        super(ErrorNames.OUTDATED_CHANGE, "Record " + record + " rev: " + currentRev + ", request rev: " + requestRev);
    }

    public OutdatedChangeException(String message) {
        super(ErrorNames.OUTDATED_CHANGE, message);
    }

    @Override
    public int getHttpStatusCode() {
        return HttpStatus.SC_409_CONFLICT;
    }
}
