package ru.yandex.chemodan.app.dataapi.api.deltas;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.chemodan.app.dataapi.api.data.field.DataField;
import ru.yandex.chemodan.app.dataapi.api.data.field.DataFieldMarshallerUnmarshaller;
import ru.yandex.chemodan.app.dataapi.api.data.record.SimpleRecordId;
import ru.yandex.chemodan.util.bender.JsonFieldLevelUnmarshaller;
import ru.yandex.misc.bender.parse.BenderJsonNode;
import ru.yandex.misc.bender.parse.ParseResult;
import ru.yandex.misc.bender.parse.UnmarshallerContext;
import ru.yandex.misc.bender.serialize.BenderJsonWriter;
import ru.yandex.misc.bender.serialize.MarshallerContext;
import ru.yandex.misc.bender.serialize.ToFieldMarshaller;
import ru.yandex.misc.xml.stream.XmlWriter;

/**
 * @author tolmalev
 */
public class RecordChangeMarshallerUnmarshaller implements JsonFieldLevelUnmarshaller, ToFieldMarshaller {
    private static final String OP = "op";
    private static final String FORCED = "forced";
    private static final String COLLECTION_ID = "collectionId";
    private static final String RECORD_ID = "recordId";
    private static final String DATA = "data";
    private static final String CHANGES = "changes";

    private static final FieldChangeMarshallerUnmarshaller fieldChangeMarshaller
            = new FieldChangeMarshallerUnmarshaller();
    private static final DataFieldMarshallerUnmarshaller dataFieldMarshaller
            = new DataFieldMarshallerUnmarshaller();

    protected void writeJson(BenderJsonWriter json, Object o) {
        RecordChange recordChange = (RecordChange) o;

        json.writeObjectStart();

        json.writeFieldName(OP);
        json.writeString(recordChange.type.name().toLowerCase());

        json.writeFieldName(COLLECTION_ID);
        json.writeString(recordChange.collectionId);

        json.writeFieldName(RECORD_ID);
        json.writeString(recordChange.recordId);

        if (recordChange.type == RecordChangeType.INSERT
                || recordChange.type == RecordChangeType.SET)
        {
            json.writeFieldName(DATA);
            json.writeObjectStart();

            for (FieldChange change : recordChange.fieldChanges) {
                json.writeFieldName(change.key);
                dataFieldMarshaller.writeJsonToField(json, change.getValue(), null);
            }

            json.writeObjectEnd();
        } else if (recordChange.type == RecordChangeType.UPDATE) {
            json.writeFieldName(CHANGES);
            json.writeArrayStart();

            for (FieldChange change : recordChange.fieldChanges) {
                fieldChangeMarshaller.writeJsonToField(json, change, null);
            }

            json.writeArrayEnd();
        }

        json.writeObjectEnd();
    }

    @Override
    public ParseResult<Object> parseJsonNode(BenderJsonNode json, UnmarshallerContext context) {
        SimpleRecordId recordId = new SimpleRecordId(
                json.getField(COLLECTION_ID).get().getValueAsString(),
                json.getField(RECORD_ID).get().getValueAsString()
        );
        RecordChangeType type =
                RecordChangeType.R.valueOf(json.getField(OP).get().getValueAsString());

        RecordChange result;
        if (type == RecordChangeType.INSERT || type == RecordChangeType.SET) {
            MapF<String, DataField> data = Cf.hashMap();

            if (json.getFieldNames().containsTs(DATA)) {
                BenderJsonNode jsonNode = json.getField(DATA).get();
                for (String field : jsonNode.getFieldNames()) {
                    data.put(field, (DataField) dataFieldMarshaller
                            .parseJsonNode(jsonNode.getField(field).get(), null).getOrThrow());
                }
            }
            if (type == RecordChangeType.INSERT) {
                result = RecordChange.insert(recordId, data);

            } else if (json.getField(FORCED).isMatch(BenderJsonNode::getBooleanValueOrFalse)) {
                result = RecordChange.setForced(recordId, data);

            } else {
                result = RecordChange.set(recordId, data);
            }
        } else if (type == RecordChangeType.UPDATE) {
            ListF<FieldChange> changes = Cf.arrayList();
            for (BenderJsonNode elem : json.getField(CHANGES).get().getArrayElements()) {
                changes.add((FieldChange) fieldChangeMarshaller .parseJsonNode(elem, null).getOrThrow());
            }
            result = RecordChange.update(recordId, changes);
        } else if (type == RecordChangeType.DELETE) {
            result = RecordChange.delete(recordId);
        } else {
            return ParseResult.failure("Unknown type " + type);
        }
        return ParseResult.result(result);
    }

    @Override
    public void writeXmlToField(XmlWriter writer, Object fieldValue, MarshallerContext context) {
        RecordChange recordChange = (RecordChange) fieldValue;

        writer.textElement("type", recordChange.type.name().toLowerCase());
        writer.textElement("collection-id", recordChange.collectionId);
        writer.textElement("record-id", recordChange.recordId);
        for (FieldChange fieldChange : recordChange.fieldChanges) {
            writer.startElement("field-change");
            writer.textElement("type", fieldChange.type.name().toLowerCase());
            writer.textElement("key", fieldChange.key);
            if (fieldChange.type == FieldChange.FieldChangeType.PUT) {
                writer.startElement("value");
                dataFieldMarshaller.writeXmlToField(writer, fieldChange.getValue(), context);
                writer.endElement();

//                    fieldChange.getValue()
//                    xml.textElement("value");
            }
            writer.endElement();
        }
    }

    public void writeJsonToField(BenderJsonWriter writer, Object fieldValue, MarshallerContext context) {
        writeJson(writer, fieldValue);
    }

    @Override
    public String getXmlFieldTextValue(Object o, MarshallerContext marshallerContext) {
        throw new RuntimeException("Not supported");
    }

    @Override
    public String getJsonFieldTextValue(Object o, MarshallerContext marshallerContext) {
        throw new RuntimeException("Not supported");
    }
}
