package ru.yandex.chemodan.app.dataapi.api.deltas;

import ru.yandex.chemodan.app.dataapi.ErrorNames;
import ru.yandex.chemodan.app.dataapi.utils.HttpStatusCodeSourceWithErrorLevel;
import ru.yandex.commune.a3.action.A3Exception;
import ru.yandex.misc.io.http.HttpStatus;

/**
 * @author tolmalev
 */
public class TooNewChangeException extends A3Exception implements HttpStatusCodeSourceWithErrorLevel {

    public TooNewChangeException(long currentRev, long requestRev) {
        super(ErrorNames.TOO_NEW_CHANGE, "Current rev: " + currentRev + ", request rev: " + requestRev);
    }

    @Override
    public int getHttpStatusCode() {
        return HttpStatus.SC_412_PRECONDITION_FAILED;
    }
}
