package ru.yandex.chemodan.app.dataapi.api.deltas.cleaning;

import java.sql.ResultSet;
import java.sql.SQLException;

import org.springframework.jdbc.core.RowMapper;

/**
 * @author yashunsky
 */
public class DbRevisionMapper implements RowMapper<DbRevisionPojo> {

    public static final DbRevisionMapper M = new DbRevisionMapper();

    @Override
    public DbRevisionPojo mapRow(ResultSet rs, int rowNum) throws SQLException {
        String handle = rs.getString("handle");
        String appName = rs.getString("app");
        String dbId = rs.getString("dbId");
        String uid = rs.getString("user_id");
        long rev = rs.getLong("rev");
        long minDelta = rs.getLong("minRev");
        long size = rs.getLong("size");
        long recordsCount = rs.getLong("records_count");

        return new DbRevisionPojo(handle, appName, dbId, uid, rev, minDelta, size, recordsCount);
    }
}
