package ru.yandex.chemodan.app.dataapi.api.deltas.cleaning;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;

import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author yashunsky
 */

@BenderBindAllFields
public class DbRevisionPojo extends DefaultObject {
    public final String handle;
    public final String appName;
    public final String dbId;
    public final String uid;
    public final long rev;
    public final long minDelta;
    public final long size;
    public final long recordsCount;

    public DbRevisionPojo(String handle, String appName, String dbId, String uid, long rev, long minDelta, long size, long recordsCount) {
        this.handle = handle;
        this.appName = appName;
        this.dbId = dbId;
        this.uid = uid;
        this.rev = rev;
        this.minDelta = minDelta;
        this.size = size;
        this.recordsCount = recordsCount;
    }

    public JsonNode asJsonNode() {
        ObjectNode row = RetrieveDbsRevisionsRunner.jsonNodeFactory.objectNode();
        row.put("handle", handle);
        row.put("appName", appName);
        row.put("dbId", dbId);
        row.put("uid", uid);
        row.put("rev", rev);
        row.put("minDelta", minDelta);
        row.put("size", size);
        row.put("recordsCount", recordsCount);
        return row;
    }
}
