package ru.yandex.chemodan.app.dataapi.api.deltas.cleaning;

import lombok.AllArgsConstructor;
import lombok.Value;
import lombok.With;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;

import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.function.Function;
import ru.yandex.commune.bazinga.BazingaBender;
import ru.yandex.commune.zk2.ZkPath;
import ru.yandex.commune.zk2.primitives.registry.ZkPathEscaping;
import ru.yandex.commune.zk2.primitives.registry.ZkRegistry;
import ru.yandex.misc.bender.Bender;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;

/**
 * @author friendlyevil
 */
public class DeltaCleaningRegistry extends ZkRegistry<String, DeltaCleaningRegistry.DeltaCleaningPojo> {
    private static final String ID = "deltas-cleaning-state";

    public DeltaCleaningRegistry(ZkPath zkPath) {
        super(zkPath, Bender.cons(DeltaCleaningPojo.class, BazingaBender.getConfiguration()),
                d -> ID, Function.identityF(), ZkPathEscaping.asIs);
    }

    public DeltaCleaningPojo get() {
        return getO(ID).orElse(new DeltaCleaningPojo());
    }

    @BenderBindAllFields
    @With
    @Value
    @AllArgsConstructor
    public static class DeltaCleaningPojo {
        LocalDateTime dateTime;
        boolean started;
        Option<String> requestRevisionsOperationId;
        boolean requestRevisionsTaskScheduled;
        boolean requestRevisionsTaskCompleted;
        boolean uploadRevisionsTaskScheduled;
        boolean uploadRevisionsTaskCompleted;
        Option<String> mergeDeltasOperationId;
        boolean cleaningScheduled;

        public LocalDate getDate() {
            return dateTime.toLocalDate();
        }

        public DeltaCleaningPojo() {
            this(LocalDateTime.now(), false, Option.empty(), false, false, false, false, Option.empty(), false);
        }
    }
}
