package ru.yandex.chemodan.app.dataapi.api.deltas.cleaning;

import org.joda.time.LocalDate;

import ru.yandex.chemodan.app.dataapi.worker.DataApiCronTask;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.commune.bazinga.scheduler.schedule.Schedule;
import ru.yandex.commune.bazinga.scheduler.schedule.ScheduleCron;
import ru.yandex.commune.bazinga.scheduler.schedule.ScheduleWithRetry;
import ru.yandex.misc.lang.Validate;
import ru.yandex.misc.time.MoscowTime;

/**
 * @author yashunsky
 */
public class DeltasCleaningCronTask extends DataApiCronTask {

    private final DeltasCleaningRoutines deltasCleaningRoutines;
    private final int executionHour;

    public DeltasCleaningCronTask(DeltasCleaningRoutines deltasCleaningRoutines, int executionHour) {
        Validate.isTrue(executionHour >= 0 && executionHour < 24);
        this.deltasCleaningRoutines = deltasCleaningRoutines;
        this.executionHour = executionHour;
    }

    @Override
    public Schedule cronExpression() {
        return new ScheduleWithRetry(new ScheduleCron("0 " + executionHour + " * * *", MoscowTime.TZ), 24);
    }

    @Override
    public void execute(ExecutionContext executionContext) throws Exception {
        if (deltasCleaningRoutines.isScalableDeltasCleaningEnabled()) {
            return;
        }
        deltasCleaningRoutines.retrieveCleaningInfoAndScheduleCleaning(LocalDate.now());
    }
}
