package ru.yandex.chemodan.app.dataapi.api.deltas.cleaning;

import ru.yandex.misc.monica.annotation.GroupByDefault;
import ru.yandex.misc.monica.annotation.MonicaMetric;
import ru.yandex.misc.monica.annotation.MonicaStaticRegistry;
import ru.yandex.misc.monica.core.blocks.Value;
import ru.yandex.misc.monica.core.name.MetricGroupName;
import ru.yandex.misc.monica.core.name.MetricName;

/**
 * @author friendlyevil
 */
public class DeltasCleaningMetrics {
    @MonicaMetric(description = "Time from start of deltas cleaning to it's end")
    @GroupByDefault
    public static Value<Long> cleaningLag = new Value<>(0L);

    static {
        MonicaStaticRegistry.register(
                DeltasCleaningMetrics.class,
                new MetricGroupName(
                        "dataapi-worker-deltas-cleaning-metrics",
                        new MetricName("dataapi-worker", "deltas-cleaning-metrics"),
                        "Dataapi worker deltas cleaning metrics"
                )
        );
    }
}
