package ru.yandex.chemodan.app.dataapi.api.deltas.cleaning;

import lombok.AllArgsConstructor;

import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.lang.DefaultToString;

/**
 * @author friendlyevil
 */
@BenderBindAllFields
@AllArgsConstructor
public class DeltasCleaningStats extends DefaultToString {
    CleaningStageStatus requestRevisions;
    CleaningStageStatus uploadRevisions;
    CleaningStageStatus mergeDeltaResult;
    CleaningStageStatus cleaning;

    public DeltasCleaningStats() {
        this(CleaningStageStatus.NOT_STARTED,
                CleaningStageStatus.NOT_STARTED,
                CleaningStageStatus.NOT_STARTED,
                CleaningStageStatus.NOT_STARTED);
    }

    public enum CleaningStageStatus {
        NOT_STARTED,
        SCHEDULED,
        COMPLETED;

        public static CleaningStageStatus getStatus(boolean scheduled, boolean complete) {
            if (!scheduled) {
                return NOT_STARTED;
            } else if (!complete) {
                return SCHEDULED;
            } else {
                return COMPLETED;
            }
        }
    }
}

