package ru.yandex.chemodan.app.dataapi.api.deltas.cleaning;

import org.joda.time.Duration;
import org.joda.time.Instant;

import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.commune.bazinga.scheduler.OnetimeTaskSupport;
import ru.yandex.commune.bazinga.scheduler.TaskQueueName;
import ru.yandex.commune.bazinga.scheduler.schedule.RescheduleConstant;
import ru.yandex.commune.bazinga.scheduler.schedule.ReschedulePolicy;
import ru.yandex.inside.yt.kosher.cypress.YPath;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author yashunsky
 */
public class DeltasCleaningTask extends OnetimeTaskSupport<DeltasCleaningTask.Parameters> {
    public static final TaskQueueName DELETE_DELTAS_QUEUE = new TaskQueueName("dataapi-delete-deltas");
    private final DeltasCleaningRoutines deltasCleaningRoutines;

    public DeltasCleaningTask(
            YPath cleaningInfoYtPath, long lowerRowIndex, long upperRowIndex, Instant now)
    {
        super(new Parameters(cleaningInfoYtPath.toString(), lowerRowIndex, upperRowIndex, now));
        deltasCleaningRoutines = null;
    }

    public DeltasCleaningTask(DeltasCleaningRoutines deltasCleaningRoutines) {
        super(Parameters.class);
        this.deltasCleaningRoutines = deltasCleaningRoutines;
    }

    @Override
    protected void execute(Parameters parameters, ExecutionContext context) throws Exception {
        YPath pathWithRange = YPath.simple(parameters.cleaningInfoYtPath)
                .withRange(parameters.lowerRowIndex, parameters.upperRowIndex);
        deltasCleaningRoutines.cleanDeltas(pathWithRange, parameters.now);
    }

    @Override
    public int priority() {
        return 0;
    }

    @Override
    public TaskQueueName queueName() {
        return DELETE_DELTAS_QUEUE;
    }

    @Override
    public Duration timeout() {
        return Duration.standardHours(1);
    }

    @BenderBindAllFields
    public static class Parameters extends DefaultObject {
        public final String cleaningInfoYtPath;
        public final long lowerRowIndex;
        public final long upperRowIndex;
        public final Instant now;

        public Parameters(String cleaningInfoYtPath, long lowerRowIndex, long upperRowIndex, Instant now) {
            this.cleaningInfoYtPath = cleaningInfoYtPath;
            this.lowerRowIndex = lowerRowIndex;
            this.upperRowIndex = upperRowIndex;
            this.now = now;
        }
    }

    @Override
    public ReschedulePolicy reschedulePolicy() {
        return new RescheduleConstant(Duration.standardMinutes(5), 144);
    }
}
