package ru.yandex.chemodan.app.dataapi.api.deltas.cleaning;

import java.util.concurrent.Semaphore;

import lombok.Getter;
import org.joda.time.Duration;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.function.Function0;
import ru.yandex.chemodan.app.dataapi.core.dao.usermeta.UserMetaManager;
import ru.yandex.chemodan.app.dataapi.core.dao.usermeta.UserMetaManagerWithSemaphore;
import ru.yandex.chemodan.app.dataapi.core.ratelimiter.chunk.auto.AutoUserAwareRwRateLimiter;
import ru.yandex.chemodan.ratelimiter.chunk.auto.MetricsConfiguration;
import ru.yandex.chemodan.ratelimiter.chunk.auto.RateLimitersMetrics;
import ru.yandex.chemodan.util.yasm.monitor.YasmMonitor;
import ru.yandex.commune.db.shard2.ShardManager2;
import ru.yandex.commune.dynproperties.DynamicProperty;
import ru.yandex.misc.worker.spring.DelayingWorkerServiceBeanSupport;

/**
 * @author yashunsky
 */
@Getter
public class DynamicDeltasCleaningControl extends DelayingWorkerServiceBeanSupport {
    private final AutoUserAwareRwRateLimiter autoRateLimiter;

    private final DynamicProperty<Double> nominalRps;
    private final DynamicProperty<Boolean> autoEnabled;
    private final DynamicProperty<Integer> chunkSize;
    private final DynamicProperty<Long> maxTimeSlot;
    private final DynamicProperty<ListF<String>> ignoredHosts;


    public DynamicDeltasCleaningControl(String sharpeiId, ShardManager2 dataShardManager, UserMetaManager userMetaManager,
            YasmMonitor yasmMonitor, MetricsConfiguration metricsConfiguration, RateLimitersMetrics rateLimitersMetrics,
            Duration meterInterval, Duration averageInterval, Duration maintenancePeriod, int sharpeiMaxConnections)
    {

        String prefix = sharpeiId + '-';
        this.nominalRps =
                DynamicProperty.cons(prefix + "deltas-cleaning-rate-limit-A--nominal-rate[rps]", 10.0);
        this.autoEnabled =
                DynamicProperty.cons(prefix + "deltas-cleaning-rate-limit-B--auto-enabled", true);
        this.chunkSize =
                DynamicProperty.cons(prefix + "deltas-cleaning-rate-limit-C--chunkSize", 100);
        this.maxTimeSlot =
                DynamicProperty.cons(prefix + "deltas-cleaning-rate-limit-D--maxTimeSlot[ms]", 10000L);
        this.ignoredHosts =
                DynamicProperty.cons(prefix + "deltas-cleaning-rate-limit-E--ignored-hosts", Cf.list());

        UserMetaManagerWithSemaphore userMetaManagerWithSemaphore = new UserMetaManagerWithSemaphore(userMetaManager);
        Semaphore sharpeiSemaphore = new Semaphore(sharpeiMaxConnections);

        autoRateLimiter = new AutoUserAwareRwRateLimiter(
                dataShardManager, userMetaManagerWithSemaphore, sharpeiSemaphore,
                yasmMonitor, metricsConfiguration, rateLimitersMetrics,
                rateSupplier(), (shard) -> rateSupplier().apply(), rateSupplier(), rateSupplier(),
                () -> 1.0, () -> 1.0, () -> 0.0, ignoredHosts::get, autoEnabled::get,
                maxTimeSlot::get, Option::empty, chunkSize::get,
                meterInterval, averageInterval);

        setDelay(maintenancePeriod);
    }

    @Override
    protected void execute() throws Exception {
        autoRateLimiter.maintain();
    }

    private Function0<Double> rateSupplier() {
        return () -> nominalRps.get() * chunkSize.get() / 1000;
    }
}
