package ru.yandex.chemodan.app.dataapi.api.deltas.cleaning;

import net.jodah.failsafe.RetryPolicy;

import ru.yandex.bolts.collection.IteratorF;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.core.dao.ShardPartitionLocator;
import ru.yandex.chemodan.app.dataapi.core.dao.data.DatabasesJdbcDao;
import ru.yandex.chemodan.ratelimiter.chunk.ChunkRateLimiter;
import ru.yandex.chemodan.util.retry.RetryManager;

/**
 * @author yashunsky
 */
public class PartitionDbRevisionsIterator implements IteratorF<DbRevisionPojo> {
    private final DatabasesJdbcDao databasesDao;
    private final int pageSize;
    private final ShardPartitionLocator shardPartition;
    private IteratorF<DbRevisionPojo> batch;
    private RetryManager<ListF<DbRevisionPojo>> retryManager;
    private ChunkRateLimiter rateLimiter;

    public PartitionDbRevisionsIterator(
            DatabasesJdbcDao databasesDao,
            ShardPartitionLocator shardPartition,
            int pageSize,
            RetryPolicy retryPolicy,
            ChunkRateLimiter rateLimiter)
    {
        this.databasesDao = databasesDao;
        this.pageSize = pageSize;
        this.shardPartition = shardPartition;
        this.retryManager = new RetryManager<ListF<DbRevisionPojo>>().withRetryPolicy(retryPolicy);
        this.rateLimiter = rateLimiter;
        updateBatch(Option.empty());
    }

    private void updateBatch(Option<String> offsetHandle) {
        batch = retryManager.get(() -> findDatabases(offsetHandle)).iterator();
    }

    private ListF<DbRevisionPojo> findDatabases(Option<String> offsetHandle) {
        return rateLimiter.acquirePermitAndExecute(pageSize,
                () -> databasesDao.findAllDatabases(shardPartition, pageSize, offsetHandle));
    }

    @Override
    public boolean hasNext() {
        return batch.hasNext();
    }

    @Override
    public DbRevisionPojo next() {
        DbRevisionPojo result = batch.next();
        if (!batch.hasNext()) {
            updateBatch(Option.of(result.handle));
        }
        return result;
    }

}
