package ru.yandex.chemodan.app.dataapi.api.deltas.cleaning;

import lombok.Value;
import org.joda.time.Duration;
import org.joda.time.LocalDate;

import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.commune.bazinga.scheduler.OnetimeTaskSupport;
import ru.yandex.commune.bazinga.scheduler.TaskQueueName;
import ru.yandex.commune.bazinga.scheduler.schedule.RescheduleConstant;
import ru.yandex.commune.bazinga.scheduler.schedule.ReschedulePolicy;
import ru.yandex.commune.dynproperties.DynamicProperty;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;

/**
 * @author friendlyevil
 */
public class RequestRevisionsTask extends OnetimeTaskSupport<RequestRevisionsTask.Parameters> {
    private DeltasCleaningRoutines deltasCleaningRoutines;
    private DeltaCleaningRegistry deltaCleaningRegistry;

    private final DynamicProperty<Long> waitYtTimeoutMs =
            DynamicProperty.cons("datasync-deltas-cleaning-wait-yt-timeout-ms", 10000L);

    public RequestRevisionsTask(LocalDate date) {
        super(new Parameters(date));
    }

    public RequestRevisionsTask(DeltasCleaningRoutines deltasCleaningRoutines,
                                DeltaCleaningRegistry deltaCleaningRegistry)
    {
        super(Parameters.class);
        this.deltasCleaningRoutines = deltasCleaningRoutines;
        this.deltaCleaningRegistry = deltaCleaningRegistry;
    }

    @Override
    protected void execute(Parameters parameters, ExecutionContext context) throws Exception {
        deltasCleaningRoutines.scheduleAndWaitRequestRevisionYtOperation(parameters.getDate(), waitYtTimeoutMs.get());
        deltaCleaningRegistry.put(deltaCleaningRegistry.get().withRequestRevisionsTaskCompleted(true));
    }

    @Override
    public int priority() {
        return 1;
    }

    @Override
    public Duration timeout() {
        return Duration.standardHours(3);
    }

    @Override
    public ReschedulePolicy reschedulePolicy() {
        return new RescheduleConstant(Duration.standardMinutes(2), 5);
    }

    @Override
    public TaskQueueName queueName() {
        return DeltasCleaningTask.DELETE_DELTAS_QUEUE;
    }

    @BenderBindAllFields
    @Value
    public static class Parameters {
        LocalDate date;
    }
}
