package ru.yandex.chemodan.app.dataapi.api.deltas.cleaning;

import lombok.Value;
import org.joda.time.Duration;
import org.joda.time.LocalDate;

import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.commune.bazinga.scheduler.OnetimeTaskSupport;
import ru.yandex.commune.bazinga.scheduler.TaskQueueName;
import ru.yandex.commune.bazinga.scheduler.schedule.RescheduleConstant;
import ru.yandex.commune.bazinga.scheduler.schedule.ReschedulePolicy;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;

/**
 * @author friendlyevil
 */
public class UploadRevisionsTask extends OnetimeTaskSupport<UploadRevisionsTask.Parameters> {
    private RetrieveDbsRevisionsRunner revisionsRunner;
    private DeltaCleaningRegistry deltaCleaningRegistry;

    public UploadRevisionsTask(LocalDate date) {
        super(new Parameters(date));
    }

    public UploadRevisionsTask(RetrieveDbsRevisionsRunner revisionsRunner, DeltaCleaningRegistry deltaCleaningRegistry) {
        super(Parameters.class);
        this.revisionsRunner = revisionsRunner;
        this.deltaCleaningRegistry = deltaCleaningRegistry;
    }

    @Override
    public int priority() {
        return 1;
    }

    @Override
    public Duration timeout() {
        return Duration.standardHours(12);
    }

    @Override
    public ReschedulePolicy reschedulePolicy() {
        return new RescheduleConstant(Duration.standardMinutes(2), 4);
    }

    @Override
    protected void execute(Parameters parameters, ExecutionContext context) throws Exception {
        revisionsRunner.scalableRetrieve(parameters.getDate());
        deltaCleaningRegistry.put(deltaCleaningRegistry.get().withUploadRevisionsTaskCompleted(true));
    }

    @Override
    public TaskQueueName queueName() {
        return DeltasCleaningTask.DELETE_DELTAS_QUEUE;
    }

    @BenderBindAllFields
    @Value
    public static class Parameters {
        LocalDate date;
    }
}
