package ru.yandex.chemodan.app.dataapi.api.deltas.cleaning;

import lombok.Value;
import org.joda.time.Duration;

import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.commune.bazinga.scheduler.OnetimeTaskSupport;
import ru.yandex.commune.bazinga.scheduler.TaskQueueName;
import ru.yandex.commune.bazinga.scheduler.schedule.RescheduleConstant;
import ru.yandex.commune.bazinga.scheduler.schedule.ReschedulePolicy;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;

/**
 * @author friendlyevil
 */
public class UploadShardRevisionsToYtTask extends OnetimeTaskSupport<UploadShardRevisionsToYtTask.Parameters> {
    public static final TaskQueueName UPLOAD_REVISIONS_QUEUE = new TaskQueueName("dataapi-upload-revisions");
    private RetrieveDbsRevisionsRunner retrieveDbsRevisionsRunner;

    public UploadShardRevisionsToYtTask(int shardNumber) {
        super(new Parameters(shardNumber));
    }

    public UploadShardRevisionsToYtTask(RetrieveDbsRevisionsRunner retrieveDbsRevisionsRunner) {
        super(Parameters.class);
        this.retrieveDbsRevisionsRunner = retrieveDbsRevisionsRunner;
    }

    @Override
    public int priority() {
        return 0;
    }

    @Override
    public Duration timeout() {
        return Duration.standardHours(2);
    }

    @Override
    public ReschedulePolicy reschedulePolicy() {
        return new RescheduleConstant(Duration.standardMinutes(2), 10);
    }

    @Override
    protected void execute(Parameters parameters, ExecutionContext context) throws Exception {
        retrieveDbsRevisionsRunner.uploadShard(parameters.getShardId());
    }

    @Override
    public TaskQueueName queueName() {
        return UPLOAD_REVISIONS_QUEUE;
    }

    @BenderBindAllFields
    @Value
    public static class Parameters {
        int shardId;
    }
}
