package ru.yandex.chemodan.app.dataapi.api.schema;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.SetF;
import ru.yandex.chemodan.app.dataapi.api.data.field.DataField;
import ru.yandex.chemodan.app.dataapi.api.data.record.CollectionRef;
import ru.yandex.chemodan.util.exception.SchemaValidationException;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author tolmalev
 */
@BenderBindAllFields
public class CollectionSchema extends DefaultObject {
    public final String collectionId;
    public final ListF<FieldInfo> fields;
    public final SetF<String> fieldIds;

    public CollectionSchema(CollectionRef colRef, FieldInfo... fields) {
        this(colRef, Cf.list(fields));
    }

    public CollectionSchema(CollectionRef colRef, ListF<FieldInfo> fields) {
        this.collectionId = colRef.collectionId;
        this.fields = fields;
        this.fieldIds = fields.map(FieldInfo.getFieldId()).unique();
    }

    public void validateRecord(MapF<String, DataField> data) {
        for (FieldInfo field : fields) {
            field.validateField(data.getO(field.fieldId));
        }

        SetF<String> unknownFields = data.keySet().minus(fieldIds);
        if (unknownFields.isNotEmpty()) {
            throw new SchemaValidationException("Unknown fields given: " + unknownFields);
        }
    }
}
