package ru.yandex.chemodan.app.dataapi.api.schema;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.chemodan.app.dataapi.api.data.field.DataField;
import ru.yandex.chemodan.app.dataapi.api.data.record.CollectionRef;
import ru.yandex.chemodan.app.dataapi.api.data.record.DataRecord;
import ru.yandex.chemodan.app.dataapi.api.db.ref.DatabaseRef;
import ru.yandex.chemodan.util.exception.SchemaValidationException;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author tolmalev
 */
@BenderBindAllFields
public class DatabaseSchema extends DefaultObject {
    public final DatabaseRef dbRef;
    public final MapF<String, CollectionSchema> collections;

    public DatabaseSchema(DatabaseRef dbRef, CollectionSchema... collections) {
        this(dbRef, Cf.list(collections));
    }

    public DatabaseSchema(DatabaseRef dbRef, ListF<CollectionSchema> collections) {
        this.dbRef = dbRef;
        this.collections = collections.toMapMappingToKey(collectionSchema -> collectionSchema.collectionId);
    }

    public static DatabaseSchema withSingleCollection(CollectionRef colRef, FieldInfo... fields) {
        CollectionSchema collectionSchema = new CollectionSchema(colRef, Cf.list(fields));
        return new DatabaseSchema(colRef.dbRef(), Cf.list(collectionSchema));
    }

    public void validateRecord(DataRecord record) {
        validateRecord(record.getCollectionId(), record.getData());
    }

    void validateRecord(String collectionId, MapF<String, DataField> data) {
        if (!collections.containsKeyTs(collectionId)) {
            throw new SchemaValidationException("Unknown collection " + collectionId);
        }

        collections.getTs(collectionId).validateRecord(data);
    }
}
