package ru.yandex.chemodan.app.dataapi.api.schema;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.function.Function;
import ru.yandex.chemodan.app.dataapi.api.data.field.DataField;
import ru.yandex.chemodan.app.dataapi.api.data.field.DataFieldType;
import ru.yandex.chemodan.util.exception.SchemaValidationException;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author tolmalev
 */
@BenderBindAllFields
public class FieldInfo extends DefaultObject {
    public final String fieldId;
    public final boolean required;
    public final DataFieldType type;
    public final ListF<FieldValueValidator> additionalValidators;

    public FieldInfo(String fieldId, boolean required, DataFieldType type) {
        this.fieldId = fieldId;
        this.required = required;
        this.type = type;
        this.additionalValidators = Cf.list();
    }

    public FieldInfo(String fieldId, boolean required, DataFieldType type,
            FieldValueValidator additionalValidator)
    {
        this(fieldId, required, type, Cf.list(additionalValidator));
    }

    public FieldInfo(String fieldId, boolean required, DataFieldType type,
            ListF<FieldValueValidator> additionalValidators)
    {
        this.fieldId = fieldId;
        this.required = required;
        this.type = type;
        this.additionalValidators = additionalValidators;
    }

    public void validateField(Option<DataField> fieldO) {
        if (!fieldO.isPresent()) {
            if (required) {
                throw new SchemaValidationException("Required field not given: " + fieldId);
            }
            return;
        }
        DataField field = fieldO.get();
        if (field.fieldType != type) {
            throw new SchemaValidationException(
                    "Invalid field type: " + fieldId
                    + ". Must be " + type
                    + ", given " + field.fieldType);
        }
        for (FieldValueValidator validator : additionalValidators) {
            validator.validateFieldValue(field);
        }
    }

    public static Function<FieldInfo, String> getFieldId() {
        return fieldInfo -> fieldInfo.fieldId;
    }
}
