package ru.yandex.chemodan.app.dataapi.api.schema;

import com.fasterxml.jackson.databind.ObjectMapper;

import ru.yandex.chemodan.app.dataapi.api.data.field.DataField;
import ru.yandex.chemodan.util.exception.SchemaValidationException;

/**
 * @author tolmalev
 */
public class JsonStringValueValidator extends StringValueValidator {
    private static final ObjectMapper mapper = new ObjectMapper();

    public JsonStringValueValidator(int minLength, int maxLength) {
        super(minLength, maxLength);
    }

    public JsonStringValueValidator(int minLength) {
        super(minLength);
    }

    @Override
    public void validateFieldValue(DataField field) {
        super.validateFieldValue(field);

        String str = (String) field.value;

        try {
            mapper.readTree(str);
        } catch (Exception e) {
            throw new SchemaValidationException("Value isn't json");
        }
    }
}
