package ru.yandex.chemodan.app.dataapi.api.schema;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.app.dataapi.api.data.field.DataField;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author tolmalev
 */
@BenderBindAllFields
public class ListValueValidator extends DefaultObject implements FieldValueValidator {

    public final ListF<FieldValueValidator> itemValidators;

    public ListValueValidator(FieldValueValidator itemValidator) {
        this(Cf.list(itemValidator));
    }

    public ListValueValidator(ListF<FieldValueValidator> itemValidators) {
        this.itemValidators = itemValidators;
    }

    @Override
    public void validateFieldValue(DataField field) {
        for (DataField item : (ListF<DataField>) field.value) {
            for (FieldValueValidator validator : itemValidators) {
                validator.validateFieldValue(item);
            }
        }
    }
}
