package ru.yandex.chemodan.app.dataapi.api.schema;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.data.field.DataField;
import ru.yandex.chemodan.app.dataapi.api.data.field.DataFieldType;
import ru.yandex.chemodan.util.exception.SchemaValidationException;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author tolmalev
 */
@BenderBindAllFields
public class StringValueValidator extends DefaultObject implements FieldValueValidator {

    public final int minLength;
    public final Option<Integer> maxLength;

    public StringValueValidator(int minLength, int maxLength) {
        this.minLength = minLength;
        this.maxLength = Option.of(maxLength);
    }

    public StringValueValidator(int minLength) {
        this.minLength = minLength;
        this.maxLength = Option.empty();
    }

    @Override
    public void validateFieldValue(DataField field) {
        if (field.fieldType != DataFieldType.STRING) {
            throw new SchemaValidationException(
                    "Invalid field type. Must be STRING, given " + field.fieldType);
        }
        String str = (String) field.value;

        if (str.length() < minLength) {
            throw new SchemaValidationException("Too short value: " + str);
        } else if (maxLength.isPresent() && str.length() > maxLength.get()) {
            throw new SchemaValidationException("Too long value: " + str);
        }
    }
}
