package ru.yandex.chemodan.app.dataapi.apps;

import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.chemodan.app.dataapi.apps.settings.AppSettingsRegistry;
import ru.yandex.chemodan.app.dataapi.core.limiter.DatabaseLimiter;
import ru.yandex.commune.zk2.ZkPath;
import ru.yandex.commune.zk2.client.ZkManager;
import ru.yandex.misc.dataSize.DataSize;
import ru.yandex.misc.spring.ApplicationContextUtils;

/**
 * @author Denis Bakharev
 */
@Configuration
public class AppsContextConfiguration {
    @Bean
    public CompositeApplicationManager compositeApplicationManager(
            GenericApplicationManager genericManager,
            ApplicationContext applicationContext)
    {
        return new CompositeApplicationManager(genericManager,
                ApplicationContextUtils.beansOfType(applicationContext, SpecificApplicationManager.class));
    }

    @Bean
    public GenericApplicationManager genericApplicationManager(DatabaseLimiter databaseLimiter) {
        return new GenericApplicationManager(databaseLimiter);
    }

    @Bean
    public CoolLentaApplicationManager coolLentaApplicationManager() {
        return new CoolLentaApplicationManager();
    }

    @Bean
    public AppSettingsRegistry appSettingsRegistry(
            @Qualifier("zkRoot") ZkPath zkRoot,
            ZkManager zkManager,
            @Value("${dataapi.database.size.limit}")
            DataSize databaseSizeLimit,
            @Value("${dataapi.databases.count.limit}")
            int databasesCountLimit)
    {
        AppSettingsRegistry settingsRegistry = new AppSettingsRegistry(zkRoot.child("app-settings"),
                databaseSizeLimit, databasesCountLimit);

        zkManager.addClient(settingsRegistry);
        return settingsRegistry;
    }
}
