package ru.yandex.chemodan.app.dataapi.apps;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.Tuple2;
import ru.yandex.chemodan.app.dataapi.api.context.DatabaseContext;
import ru.yandex.chemodan.app.dataapi.api.context.DatabaseContextSource;
import ru.yandex.chemodan.app.dataapi.api.db.handle.DatabaseHandle;
import ru.yandex.chemodan.app.dataapi.api.db.handle.DatabaseHandles;
import ru.yandex.chemodan.app.dataapi.api.db.ref.DatabaseRef;
import ru.yandex.chemodan.app.dataapi.api.db.ref.DatabaseRefsSource;
import ru.yandex.chemodan.app.dataapi.api.deltas.DatabaseChange;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;

/**
 * @author Denis Bakharev
 */
public class CompositeApplicationManager implements ApplicationManager {
    private final GenericApplicationManager genericManager;

    private final MapF<DatabaseContext, SpecificApplicationManager> appToManager;

    CompositeApplicationManager(GenericApplicationManager genericManager,
            ListF<SpecificApplicationManager> specificManagers)
    {
        this.genericManager = genericManager;
        this.appToManager = specificManagers.toMap(manager -> new Tuple2<>(manager.getApplication(), manager));
    }

    @Override
    public void validateDatabaseCreation(DataApiUserId uid, DatabaseRef databaseRef) {
        getAppManager(databaseRef)
                .validateDatabaseCreation(uid, databaseRef);
    }

    @Override
    public void validateDatabaseUpdate(DatabaseChange change) {
        getAppManager(change.patchedDatabase())
                .validateDatabaseUpdate(change);
    }

    private HandleGenerator getHandleGenerator(DatabaseContextSource contextSrc) {
        return getSpecificManager(contextSrc)
                .map(SpecificApplicationManager::getHandleGenerator)
                .getOrElse(genericManager.handleGenerator());
    }

    public DatabaseHandle createDatabaseHandle(DataApiUserId uid, DatabaseRef dbRef) {
        return getHandleGenerator(dbRef)
                .generate(uid, dbRef);
    }

    public Option<DatabaseHandle> consPermanentDbHandleO(DataApiUserId uid, DatabaseRef dbRef) {
        return getHandleGenerator(dbRef)
                .consPermanentO(uid, dbRef);
    }

    public Option<DatabaseHandles> consPermanentDbHandlesO(DataApiUserId uid, DatabaseRefsSource refs) {
        return getHandleGenerator(refs)
                .consPermanentO(uid, refs);
    }

    ApplicationManager getAppManager(DatabaseContextSource contextSrc) {
        return getSpecificManager(contextSrc)
                .map(manager -> (ApplicationManager) manager)
                .getOrElse(genericManager);
    }

    private Option<SpecificApplicationManager> getSpecificManager(DatabaseContextSource contextSrc) {
        return appToManager.getO(contextSrc.dbContext());
    }
}
