package ru.yandex.chemodan.app.dataapi.apps;

import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.chemodan.app.dataapi.api.context.DatabaseAppContext;
import ru.yandex.chemodan.app.dataapi.api.context.DatabaseContext;
import ru.yandex.chemodan.app.dataapi.apps.profile.ProfileApplicationManager;
import ru.yandex.chemodan.app.dataapi.apps.profile.ProfileUtils;
import ru.yandex.chemodan.app.dataapi.core.dao.test.ActivateDataApiEmbeddedPg;
import ru.yandex.chemodan.app.dataapi.test.DataApiTestSupport;
import ru.yandex.misc.test.Assert;

/**
 * @author Denis Bakharev
 */
@ActivateDataApiEmbeddedPg
public class CompositeApplicationManagerIntegrationTest extends DataApiTestSupport {

    @Autowired
    public CompositeApplicationManager manager;

    @Test
    public void getAppManager_UnknownAppName_ReturnsGenericAppManager() {
        Assert.isInstance(manager.getAppManager(new DatabaseAppContext("---")),
                          GenericApplicationManager.class);
    }

    @Test
    public void getAppManager_NoAppName_ReturnsGenericAppManager() {
        Assert.isInstance(manager.getAppManager(DatabaseContext.global()),
                          GenericApplicationManager.class);
    }

    @Test
    public void getAppManager_ProfileAppName_ReturnsProfileAppManager() {
        Assert.isInstance(manager.getAppManager(ProfileUtils.PROFILE_CTX),
                          ProfileApplicationManager.class);
    }
}
