package ru.yandex.chemodan.app.dataapi.apps;

import ru.yandex.chemodan.app.dataapi.api.context.DatabaseAppContext;
import ru.yandex.chemodan.app.dataapi.api.db.ref.DatabaseRef;
import ru.yandex.chemodan.app.dataapi.api.deltas.DatabaseChange;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;

/**
 * @author tolmalev
 */
public class CoolLentaApplicationManager implements SpecificApplicationManager {
    public static final DatabaseAppContext LENTA_CTX = new DatabaseAppContext("cool_lenta");

    private static final HandleGenerator handleGenerator =
            HandleGenerator.permanent((uid, refSrc) -> {
                if (!refSrc.isBoundTo(LENTA_CTX)) {
                    throw new IllegalArgumentException("Utility supposed to generate handles for cool lenta");
                }

                return LENTA_CTX.appName() + "." + uid.toString() + "." + refSrc.databaseId();
            });

    @Override
    public DatabaseAppContext getApplication() {
        return LENTA_CTX;
    }

    @Override
    public HandleGenerator getHandleGenerator() {
        return handleGenerator;
    }

    @Override
    public void validateDatabaseCreation(DataApiUserId uid, DatabaseRef databaseRef) {
        //do nothing for speed
    }

    @Override
    public void validateDatabaseUpdate(DatabaseChange change) {
        //do nothing for speed
    }
}
