package ru.yandex.chemodan.app.dataapi.apps;

import org.joda.time.Instant;

import ru.yandex.chemodan.app.dataapi.api.db.ref.DatabaseRef;
import ru.yandex.chemodan.app.dataapi.api.deltas.DatabaseChange;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.chemodan.app.dataapi.core.limiter.DatabaseLimiter;
import ru.yandex.misc.random.Random2;

/**
 * @author Denis Bakharev
 */
public class GenericApplicationManager implements ApplicationManager {
    private static final HandleGenerator handleGenerator =
            HandleGenerator.random((uid, dbRef) ->
                    Random2.R.nextAlnum(16)
                            + uid.toString()
                            + 'U'
                            + Random2.R.nextAlnum(16)
                            + Instant.now().getMillis()
            );

    private final DatabaseLimiter limiter;

    GenericApplicationManager(DatabaseLimiter limiter) {
        this.limiter = limiter;
    }

    @Override
    public void validateDatabaseCreation(DataApiUserId uid, DatabaseRef databaseRef) {
        limiter.checkDatabasesCountLimit(uid, databaseRef);
    }

    @Override
    public void validateDatabaseUpdate(DatabaseChange change) {
        limiter.checkLimitReached(change.patchedDatabase());
    }

    HandleGenerator handleGenerator() {
        return handleGenerator;
    }
}
