package ru.yandex.chemodan.app.dataapi.apps;

import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.function.Function2;
import ru.yandex.chemodan.app.dataapi.api.db.handle.DatabaseHandle;
import ru.yandex.chemodan.app.dataapi.api.db.handle.DatabaseHandles;
import ru.yandex.chemodan.app.dataapi.api.db.ref.DatabaseRef;
import ru.yandex.chemodan.app.dataapi.api.db.ref.DatabaseRefs;
import ru.yandex.chemodan.app.dataapi.api.db.ref.DatabaseRefsSource;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class HandleGenerator {
    private final boolean permanent;

    private final Function2<DataApiUserId, DatabaseRef, String> generator;

    private HandleGenerator(boolean permanent, Function2<DataApiUserId, DatabaseRef, String> generator) {
        this.permanent = permanent;
        this.generator = generator;
    }

    public static HandleGenerator permanent(Function2<DataApiUserId, DatabaseRef, String> generator) {
        return new HandleGenerator(true, generator);
    }

    public static HandleGenerator random(Function2<DataApiUserId, DatabaseRef, String> generator) {
        return new HandleGenerator(false, generator);
    }

    Option<DatabaseHandle> consPermanentO(DataApiUserId uid, DatabaseRef dbRef) {
        return Option.when(permanent, () -> generate(uid, dbRef));
    }

    Option<DatabaseHandles> consPermanentO(DataApiUserId uid, DatabaseRefsSource refsSrc) {
        return consPermanent(uid, refsSrc.dbRefs());
    }

    private Option<DatabaseHandles> consPermanent(DataApiUserId uid, DatabaseRefs refs) {
        return Option.when(permanent,
                new DatabaseHandles(
                        refs.dbContext(),
                        refs.iterator()
                                .map(ref -> generate(uid, ref))
                                .toList()
                )
        );
    }

    public DatabaseHandle generate(DataApiUserId uid, DatabaseRef dbRef) {
        return dbRef.consHandle(generator.apply(uid, dbRef));
    }
}
