package ru.yandex.chemodan.app.dataapi.apps.profile;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.IteratorF;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.data.field.DataField;
import ru.yandex.chemodan.app.dataapi.api.data.field.DataFieldType;
import ru.yandex.chemodan.app.dataapi.api.deltas.FieldChange;
import ru.yandex.misc.lang.Check;

/**
 * @author Denis Bakharev
 */
public class FieldChangeUtils {

    public static ListF<FieldChange> createFieldChanges(MapF<String, DataField> sourceFields,
                                                        MapF<String, DataField> targetFields)
    {
        ListF<FieldChange> fieldChanges = Cf.arrayList();

        //DataField exists only in target -> add
        targetFields.filterKeys(targetKey -> !sourceFields.containsKeyTs(targetKey))
                    .forEach((targetKey, targetValue) -> fieldChanges.add(FieldChange.put(targetKey, targetValue)));

        //DataField exists only in source -> delete
        sourceFields.filterKeys(sourceKey -> !targetFields.containsKeyTs(sourceKey))
                    .forEach((sourceKey, value) -> fieldChanges.add(FieldChange.delete(sourceKey)));

        //DataField exists in both target and source -> update if data values not equal
        targetFields.filterKeys(sourceFields::containsKeyTs)
                    .forEach((targetKey, targetValue) -> {
                        DataField sourceValue = sourceFields.getTs(targetKey);
                        if (!targetValue.equals(sourceValue)) {
                            if (targetValue.fieldType == DataFieldType.LIST
                                && sourceValue.fieldType == DataFieldType.LIST)
                            {
                                ListF<FieldChange> listFieldChanges = getListFieldChanges(targetKey,
                                                                                          sourceValue.listValue(),
                                                                                          targetValue.listValue());
                                fieldChanges.addAll(listFieldChanges);
                            } else {
                                fieldChanges.add(FieldChange.put(targetKey, targetValue));
                            }
                        }
                    });

        return fieldChanges;
    }

    public static <T extends ProfileRecordSupport> ListF<FieldChange> createFieldChanges(T source, T target) {
        MapF<String, DataField> sourceFields = source.toDataMap();
        MapF<String, DataField> targetFields = target.toDataMap();

        return createFieldChanges(sourceFields, targetFields);
    }

    private static ListF<FieldChange> getListFieldChanges(String key,
                                                          ListF<DataField> source,
                                                          ListF<DataField> target)
    {
        ListF<FieldChange> result = Cf.arrayList();

        IteratorF<DataField> sourceIterator = source.iterator();
        IteratorF<DataField> targetIterator = target.iterator();

        int index = 0;

        while (sourceIterator.hasNext() || targetIterator.hasNext()) {
            Option<DataField> sourceDataO = sourceIterator.nextO();
            Option<DataField> targetDataO = targetIterator.nextO();

            if (sourceDataO.isPresent() && targetDataO.isPresent()) {
                //we have data in both source and target collections -> update to target if data values not equal
                DataField sourceData = sourceDataO.get();
                DataField targetData = targetDataO.get();
                if (!sourceData.equals(targetData)) {
                    result.add(FieldChange.putListItem(key, index, targetData));
                }
            } else if (sourceDataO.isPresent()) {
                //we have data only in source -> delete
                result.add(FieldChange.deleteListItem(key, index));

                //we have to decrement index because every FieldChange in delta applies iteratively to object that
                //changed from previous FieldChange
                index--;
            } else {
                //we have data only in target -> add
                Check.isTrue(targetDataO.isPresent());
                result.add(FieldChange.insertListItem(key, index, targetDataO.get()));
            }

            index++;
        }

        return result;
    }
}
