package ru.yandex.chemodan.app.dataapi.apps.profile;

import org.junit.Test;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.data.field.DataField;
import ru.yandex.chemodan.app.dataapi.api.deltas.FieldChange;
import ru.yandex.chemodan.app.dataapi.apps.profile.address.Address;
import ru.yandex.misc.test.Assert;

/**
 * @author Denis Bakharev
 */
public class FieldChangeUtilsTest {

    @Test
    public void createFieldChanges_SameObjects_EmptyChanges() {
        Address address = new Address("address");

        ListF<FieldChange> fieldChanges = FieldChangeUtils.createFieldChanges(address, address);

        Assert.equals(0, fieldChanges.size());
    }

    @Test
    public void createFieldChanges_NotEqualObjects_CreateChanges() {
        Address a1 = new Address("a1");
        a1.setTitle("title1");
        a1.setAddressLine(Option.of("addressLine"));
        a1.getMinedAttributes().add("same");
        a1.getMinedAttributes().add("update me");
        a1.getMinedAttributes().add("update me");
        a1.getMinedAttributes().add("delete me");

        Address a2 = new Address("a1");
        a2.setTitle("title2");
        a2.setAddressLine(Option.empty());
        a2.setAddressLineShort(Option.of("addressLineShort"));
        a2.getMinedAttributes().add("same");
        a2.getMinedAttributes().add("updated1");
        a2.getMinedAttributes().add("updated2");

        ListF<FieldChange> fieldChanges = FieldChangeUtils.createFieldChanges(a1, a2);

        Assert.equals(6, fieldChanges.size());

        Assert.assertContains(fieldChanges, FieldChange.put(Address.TITLE, DataField.string("title2")));
        Assert.assertContains(fieldChanges, FieldChange.delete(Address.ADDRESS_LINE));
        Assert.assertContains(fieldChanges,
                              FieldChange.put(Address.ADDRESS_LINE_SHORT, DataField.string("addressLineShort")));
        Assert.assertContains(fieldChanges,
                              FieldChange.putListItem(Address.MINED_ATTRIBUTES, 1, DataField.string("updated1")));
        Assert.assertContains(fieldChanges,
                              FieldChange.putListItem(Address.MINED_ATTRIBUTES, 2, DataField.string("updated2")));
        Assert.assertContains(fieldChanges,
                              FieldChange.deleteListItem(Address.MINED_ATTRIBUTES, 3));
    }

    @Test
    public void createFieldChanges_AddNewListItem_CreateChanges() {
        Address a1 = new Address("a1");
        a1.getMinedAttributes().add("update me");

        Address a2 = new Address("a1");
        a2.getMinedAttributes().add("updated");
        a2.getMinedAttributes().add("new");

        ListF<FieldChange> fieldChanges = FieldChangeUtils.createFieldChanges(a1, a2);

        Assert.equals(2, fieldChanges.size());

        Assert.assertContains(fieldChanges,
                              FieldChange.putListItem(Address.MINED_ATTRIBUTES, 0, DataField.string("updated")));
        Assert.assertContains(fieldChanges,
                              FieldChange.insertListItem(Address.MINED_ATTRIBUTES, 1, DataField.string("new")));
    }

    @Test
    public void createFieldChanges_DeleteListItems_CreateIterativeChanges() {
        Address a1 = new Address("a1");
        a1.getMinedAttributes().add("do not touch");
        a1.getMinedAttributes().add("delete me1");
        a1.getMinedAttributes().add("delete me2");

        Address a2 = new Address("a2");
        a2.getMinedAttributes().add("do not touch");

        ListF<FieldChange> fieldChanges = FieldChangeUtils.createFieldChanges(a1, a2);
        Assert.equals(2, fieldChanges.size());

        Assert.equals(fieldChanges.get(0), FieldChange.deleteListItem(Address.MINED_ATTRIBUTES, 1));
        Assert.equals(fieldChanges.get(1), FieldChange.deleteListItem(Address.MINED_ATTRIBUTES, 1));
    }
}
