package ru.yandex.chemodan.app.dataapi.apps.profile;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.function.Function;
import ru.yandex.chemodan.app.dataapi.api.data.record.CollectionRef;
import ru.yandex.chemodan.app.dataapi.api.data.record.DataRecord;
import ru.yandex.chemodan.app.dataapi.api.data.record.Entity;
import ru.yandex.chemodan.app.dataapi.api.db.Database;
import ru.yandex.chemodan.app.dataapi.api.deltas.Delta;
import ru.yandex.chemodan.app.dataapi.api.deltas.FieldChange;
import ru.yandex.chemodan.app.dataapi.api.deltas.RecordChange;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.chemodan.app.dataapi.core.datasources.disk.DiskDataSource;
import ru.yandex.chemodan.app.dataapi.core.manager.DataApiManager;
import ru.yandex.chemodan.app.dataapi.web.NotFoundException;

/**
 * @author akirakozov
 */
public abstract class GenericProfileNamespaceManagerBase<T extends Entity> extends ProfileNamespaceManagerBase {
    private final Function<DataRecord, T> unmapper;

    public GenericProfileNamespaceManagerBase(
            DataApiManager dataApiManager,
            DiskDataSource diskDataSource,
            CollectionRef colRef,
            Function<DataRecord, T> unmapper)
    {
        super(dataApiManager, diskDataSource, colRef);
        this.unmapper = unmapper;
    }

    public ListF<T> getEntitiesByUid(DataApiUserId uid) {
        return getRecords(uid).map(unmapper);
    }

    public Option<T> getEntityByUidAndIdO(DataApiUserId uid, String id) {
        return getRecord(uid, id).map(unmapper);
    }

    public T getEntityByUidAndId(DataApiUserId uid, String id) {
        return getEntityByUidAndIdO(uid, id).getOrThrow(NotFoundException.consF("Record not found: " + id));
    }

    public void setEntity(DataApiUserId uid, T entity) {
        applyDeltaWithRetries(uid,
                entity.toFieldSet()
                        .toSetChange());
    }

    public Database insertEntity(DataApiUserId uid, T entity) {
        return applyDeltaWithRetries(uid,
                entity.toFieldSet()
                        .toInsertChange());
    }

    public void deleteEntity(DataApiUserId uid, String id) {
        applyDeltaWithRetries(uid, new Delta(RecordChange.delete(colRef, id)));
    }

    public void deleteEntity(DataApiUserId uid, T entity) {
        deleteEntity(uid, entity.recordId());
    }

    protected void updateEntity(DataApiUserId uid, String id, ListF<FieldChange> fieldChanges) {
        applyDeltaWithRetries(uid, RecordChange.update(colRef, id, fieldChanges));
    }

    protected ListF<T> parseRecords(ListF<DataRecord> records) {
        return parseRecords(records, unmapper);
    }
}
