package ru.yandex.chemodan.app.dataapi.apps.profile;

import java.net.URI;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Profile;

import ru.yandex.chemodan.app.dataapi.api.DatabaseChangedEventAsyncHandler;
import ru.yandex.chemodan.app.dataapi.api.DatabaseChangedEventHandler;
import ru.yandex.chemodan.app.dataapi.apps.GenericApplicationManager;
import ru.yandex.chemodan.app.dataapi.apps.SpecificApplicationManager;
import ru.yandex.chemodan.app.dataapi.apps.profile.address.AddressChangeNormalizer;
import ru.yandex.chemodan.app.dataapi.apps.profile.address.AddressChangesAsyncHandler;
import ru.yandex.chemodan.app.dataapi.apps.profile.address.AddressDataApiDao;
import ru.yandex.chemodan.app.dataapi.apps.profile.address.AddressLinesFromMinedAttributesRemover;
import ru.yandex.chemodan.app.dataapi.apps.profile.address.AddressManager;
import ru.yandex.chemodan.app.dataapi.apps.profile.address.GeocoderHelper;
import ru.yandex.chemodan.app.dataapi.apps.profile.events.ActualEventsManager;
import ru.yandex.chemodan.app.dataapi.apps.profile.events.AsyncEventRemover;
import ru.yandex.chemodan.app.dataapi.apps.profile.events.EventCollectionChangedAsyncHandler;
import ru.yandex.chemodan.app.dataapi.apps.profile.events.EventType;
import ru.yandex.chemodan.app.dataapi.apps.profile.events.flights.ProfileFlightsManager;
import ru.yandex.chemodan.app.dataapi.apps.profile.full.FullProfileContextConfiguration;
import ru.yandex.chemodan.app.dataapi.apps.profile.geopoint.GeoPointsManager;
import ru.yandex.chemodan.app.dataapi.apps.profile.yatickets.OrdersContextConfiguration;
import ru.yandex.chemodan.app.dataapi.core.datasources.disk.DiskDataSource;
import ru.yandex.chemodan.app.dataapi.core.generic.TypeSettingsRegistry;
import ru.yandex.chemodan.app.dataapi.core.manager.DataApiManager;
import ru.yandex.chemodan.boot.value.OverridableValuePrefix;
import ru.yandex.chemodan.util.http.HttpClientConfigurator;
import ru.yandex.commune.bazinga.BazingaTaskManager;
import ru.yandex.inside.geosearch.GeosearchClient;

/**
 * @author tolmalev
 */
@Profile("dataapi")
@Import({
        FullProfileContextConfiguration.class,
        OrdersContextConfiguration.class,
})
@Configuration
public class ProfileContextConfiguration {

    @Bean
    public ProfileDatabaseSchemaRegistry profileDatabaseSchemaRegistry() {
        return new ProfileDatabaseSchemaRegistry();
    }

    @Bean
    public AddressDataApiDao addressDao(DataApiManager dataApiManager, DiskDataSource diskDataSource) {
        return new AddressDataApiDao(dataApiManager, diskDataSource);
    }

    @Bean
    public AddressManager addressesManager(AddressDataApiDao addressDao, GeocoderHelper geocoderHelper) {
        return new AddressManager(addressDao, geocoderHelper);
    }

    @Bean
    public ActualEventsManager actualEventsManager(DataApiManager dataApiManager,
            DiskDataSource diskDataSource,
            AsyncEventRemover asyncEventRemover)
    {
        return new ActualEventsManager(dataApiManager, diskDataSource, asyncEventRemover);
    }

    @Bean
    public ProfileFlightsManager profileFlightsManager(DataApiManager dataApiManager,
            DiskDataSource diskDataSource)
    {
        return new ProfileFlightsManager(dataApiManager, diskDataSource);
    }

    @Bean
    public GeoPointsManager geoPointsManager(DataApiManager dataApiManager, DiskDataSource diskDataSource) {
        return new GeoPointsManager(dataApiManager, diskDataSource);
    }

    @Bean
    public AsyncEventRemover asyncEventRemover(BazingaTaskManager bazingaTaskManager) {
        return new AsyncEventRemover(bazingaTaskManager);
    }

    @Bean
    public DatabaseChangedEventAsyncHandler flightsChangedAsyncHandler(AsyncEventRemover asyncEventRemover) {
        return new EventCollectionChangedAsyncHandler(asyncEventRemover, EventType.FLIGHT);
    }

    @Bean
    public DatabaseChangedEventHandler addressChangeNormalizer() {
        return new AddressChangeNormalizer();
    }

    @Bean
    public GeocoderHelper geocoderHelper(GeosearchClient geosearchClient)
    {
        return new GeocoderHelper(geosearchClient);
    }

    @Bean
    public GeosearchClient geosearchClient(
            @Value("${geosearch.uri}") URI geosearchUri,
            @Value("${geosearch.origin}") String origin)
    {
        return new GeosearchClient(geosearchUri, origin, geosearchHttpClientConfigurator().configure());
    }

    @Bean
    @OverridableValuePrefix("geosearch")
    public HttpClientConfigurator geosearchHttpClientConfigurator() {
        return new HttpClientConfigurator();
    }

    @Bean
    public DatabaseChangedEventAsyncHandler addressChangesAsyncHandler(BazingaTaskManager bazingaTaskManager) {
        return new AddressChangesAsyncHandler(bazingaTaskManager);
    }

    @Bean
    public DatabaseChangedEventHandler addressLinesFromMinedAttributesRemover() {
        return new AddressLinesFromMinedAttributesRemover();
    }

    @Bean
    public SpecificApplicationManager profileApplicationManager(
            GenericApplicationManager genericManager,
            ProfileDatabaseSchemaRegistry schemaRegistry,
            TypeSettingsRegistry typeSettingsRegistry)
    {
        return new ProfileApplicationManager(genericManager, schemaRegistry, typeSettingsRegistry);
    }
}
