package ru.yandex.chemodan.app.dataapi.apps.profile;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.data.field.DataFieldType;
import ru.yandex.chemodan.app.dataapi.api.db.ref.DatabaseRef;
import ru.yandex.chemodan.app.dataapi.api.schema.CollectionSchema;
import ru.yandex.chemodan.app.dataapi.api.schema.DatabaseSchema;
import ru.yandex.chemodan.app.dataapi.api.schema.FieldInfo;
import ru.yandex.chemodan.app.dataapi.api.schema.JsonStringValueValidator;
import ru.yandex.chemodan.app.dataapi.api.schema.ListValueValidator;
import ru.yandex.chemodan.app.dataapi.api.schema.StringValueValidator;
import ru.yandex.chemodan.app.dataapi.apps.profile.address.Address;
import ru.yandex.chemodan.app.dataapi.apps.profile.events.flights.Airline;
import ru.yandex.chemodan.app.dataapi.apps.profile.events.flights.Airport;
import ru.yandex.chemodan.app.dataapi.apps.profile.events.flights.Flight;
import ru.yandex.chemodan.app.dataapi.apps.profile.events.flights.FlightPlace;

/**
 * @author tolmalev
 */
public class ProfileDatabaseSchemaRegistry {
    private final MapF<DatabaseRef, DatabaseSchema> schemas = Cf.list(
            DatabaseSchema.withSingleCollection(ProfileUtils.ADDRESSES_COL_REF,
                    new FieldInfo(Address.LATITUDE, true, DataFieldType.DECIMAL),
                    new FieldInfo(Address.LONGITUDE, true, DataFieldType.DECIMAL),
                    new FieldInfo(Address.TITLE, true, DataFieldType.STRING),

                    new FieldInfo(Address.ADDRESS_LINE, false, DataFieldType.STRING,
                            new StringValueValidator(1)),
                    new FieldInfo(Address.ADDRESS_LINE_SHORT, false, DataFieldType.STRING,
                            new StringValueValidator(1)),

                    new FieldInfo(Address.CREATED, false, DataFieldType.TIMESTAMP),
                    new FieldInfo(Address.MODIFIED, false, DataFieldType.TIMESTAMP),
                    new FieldInfo(Address.LAST_USED, false, DataFieldType.TIMESTAMP),

                    new FieldInfo(Address.TAGS, false, DataFieldType.LIST,
                            new ListValueValidator(new StringValueValidator(3, 256))),

                    new FieldInfo(Address.MINED_ATTRIBUTES, false, DataFieldType.LIST,
                            new ListValueValidator(new StringValueValidator(0))),

                    new FieldInfo(Address.ENTRANCE_NUMBER, false, DataFieldType.STRING, new StringValueValidator(1)),
                    new FieldInfo(Address.CUSTOM_METADATA, false, DataFieldType.STRING, new JsonStringValueValidator(1))
            ),
            DatabaseSchema.withSingleCollection(ProfileUtils.FLIGHTS_COL_REF,
                    new FieldInfo(Flight.FLIGHT_NUMBER, true, DataFieldType.STRING),
                    new FieldInfo(Flight.CHECKIN_URL, false, DataFieldType.STRING),
                    new FieldInfo(Flight.DATA_SOURCE, false, DataFieldType.STRING),

                    new FieldInfo(Flight.AIRLINE_PREFIX + Airline.IATA_CODE, false, DataFieldType.STRING),
                    new FieldInfo(Flight.AIRLINE_PREFIX + Airline.ICAO_CODE, false, DataFieldType.STRING),
                    new FieldInfo(Flight.AIRLINE_PREFIX + Airline.SIRENA_CODE, false, DataFieldType.STRING),
                    new FieldInfo(Flight.AIRLINE_PREFIX + Airline.YA_SCHEDULE_ID, false, DataFieldType.STRING),
                    new FieldInfo(Flight.AIRLINE_PREFIX + Airline.NAME, false, DataFieldType.STRING),

                    new FieldInfo(Flight.DEPARTURE_PREFIX + FlightPlace.TIME, true, DataFieldType.TIMESTAMP),
                    new FieldInfo(Flight.DEPARTURE_PREFIX + FlightPlace.TZ_OFFSET, true, DataFieldType.INTEGER),
                    new FieldInfo(Flight.DEPARTURE_PREFIX + FlightPlace.GEO_ID, false, DataFieldType.INTEGER),
                    new FieldInfo(Flight.DEPARTURE_PREFIX + FlightPlace.CITY_NAME, false, DataFieldType.STRING),

                    new FieldInfo(Flight.DEPARTURE_PREFIX + FlightPlace.AIRPORT_PREFIX + Airport.IATA_CODE, false,
                            DataFieldType.STRING),
                    new FieldInfo(Flight.DEPARTURE_PREFIX + FlightPlace.AIRPORT_PREFIX + Airport.ICAO_CODE, false,
                            DataFieldType.STRING),
                    new FieldInfo(Flight.DEPARTURE_PREFIX + FlightPlace.AIRPORT_PREFIX + Airport.SIRENA_CODE, false,
                            DataFieldType.STRING),
                    new FieldInfo(Flight.DEPARTURE_PREFIX + FlightPlace.AIRPORT_PREFIX + Airport.NAME, false,
                            DataFieldType.STRING),
                    new FieldInfo(Flight.DEPARTURE_PREFIX + FlightPlace.AIRPORT_PREFIX + Airport.YA_SCHEDULE_ID, false,
                            DataFieldType.STRING),

                    new FieldInfo(Flight.ARRIVAL_PREFIX + FlightPlace.TIME, false, DataFieldType.TIMESTAMP),
                    new FieldInfo(Flight.ARRIVAL_PREFIX + FlightPlace.TZ_OFFSET, false, DataFieldType.INTEGER),
                    new FieldInfo(Flight.ARRIVAL_PREFIX + FlightPlace.GEO_ID, false, DataFieldType.INTEGER),
                    new FieldInfo(Flight.ARRIVAL_PREFIX + FlightPlace.CITY_NAME, false, DataFieldType.STRING),

                    new FieldInfo(Flight.ARRIVAL_PREFIX + FlightPlace.AIRPORT_PREFIX + Airport.IATA_CODE, false,
                            DataFieldType.STRING),
                    new FieldInfo(Flight.ARRIVAL_PREFIX + FlightPlace.AIRPORT_PREFIX + Airport.ICAO_CODE, false,
                            DataFieldType.STRING),
                    new FieldInfo(Flight.ARRIVAL_PREFIX + FlightPlace.AIRPORT_PREFIX + Airport.SIRENA_CODE, false,
                            DataFieldType.STRING),
                    new FieldInfo(Flight.ARRIVAL_PREFIX + FlightPlace.AIRPORT_PREFIX + Airport.NAME, false,
                            DataFieldType.STRING),
                    new FieldInfo(Flight.ARRIVAL_PREFIX + FlightPlace.AIRPORT_PREFIX + Airport.YA_SCHEDULE_ID, false,
                            DataFieldType.STRING)
            ),
            DatabaseSchema.withSingleCollection(ProfileUtils.GEOPOINT_COL_REF,
                    new FieldInfo(Address.LATITUDE, true, DataFieldType.DECIMAL),
                    new FieldInfo(Address.LONGITUDE, true, DataFieldType.DECIMAL),
                    new FieldInfo(Address.TITLE, false, DataFieldType.STRING),

                    new FieldInfo(Address.TAGS, false, DataFieldType.LIST,
                            new ListValueValidator(new StringValueValidator(3, 256))
                    )
            ),
            getYaTicketsOrdersSchema()
    ).toMapMappingToKey(schema -> schema.dbRef);

    ProfileDatabaseSchemaRegistry() {
    }

    private DatabaseSchema getYaTicketsOrdersSchema() {
        //Это нужно будет переписать когда будет валидация по json схеме
        //Проблемы текущей реализации:
        //1. Хардкод строк
        //2. Внутренности map'ов не валидируются
        //3. Листы содержат объекты, они так же не валидируются
        //
        //p.s Реализовывать создание схем вручную возможно только для небольших плоских объектов.
        //в типе Order агрегирован граф из 10 обектов, плюс листы, в которых другие обхекты, в которых листы
        //см https://wiki.yandex-team.ru/disk/personality/ya-tickets

        ListF<FieldInfo> fieldInfoArr = Cf.arrayList();
        fieldInfoArr.add(new FieldInfo("order_id", true, DataFieldType.STRING));
        fieldInfoArr.add(new FieldInfo("session", true, DataFieldType.MAP));
        fieldInfoArr.add(new FieldInfo("ticket_count", true, DataFieldType.INTEGER));
        fieldInfoArr.add(new FieldInfo("order_number", false, DataFieldType.STRING));
        fieldInfoArr.add(new FieldInfo("presentation_order_number", false, DataFieldType.STRING));
        fieldInfoArr.add(new FieldInfo("code_word", false, DataFieldType.STRING));
        fieldInfoArr.add(new FieldInfo("barcode", false, DataFieldType.MAP));
        fieldInfoArr.add(new FieldInfo("pkpass_barcode", false, DataFieldType.MAP));
        fieldInfoArr.add(new FieldInfo("tickets", false, DataFieldType.LIST));

        return new DatabaseSchema(ProfileUtils.YATICKETS_DB_REF, Cf.list(new CollectionSchema(
                        ProfileUtils.YATICKETS_ORDERS_COL_REF, fieldInfoArr)));
    }

    boolean hasSchema(DatabaseRef ref) {
        return schemas.containsKeyTs(ref);
    }

    Option<DatabaseSchema> getSchemaO(DatabaseRef dbRef) {
        return schemas.getO(dbRef);
    }
}
