package ru.yandex.chemodan.app.dataapi.apps.profile;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.function.Function;
import ru.yandex.chemodan.app.dataapi.api.data.record.CollectionRef;
import ru.yandex.chemodan.app.dataapi.api.data.record.DataRecord;
import ru.yandex.chemodan.app.dataapi.api.db.Database;
import ru.yandex.chemodan.app.dataapi.api.db.ref.DatabaseRef;
import ru.yandex.chemodan.app.dataapi.api.deltas.Delta;
import ru.yandex.chemodan.app.dataapi.api.deltas.RecordChange;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.chemodan.app.dataapi.apps.profile.full.ProfilePartParser;
import ru.yandex.chemodan.app.dataapi.core.datasources.disk.DiskDataSource;
import ru.yandex.chemodan.app.dataapi.core.manager.DataApiManager;

/**
 * @author tolmalev
 */
public abstract class ProfileNamespaceManagerBase extends ProfileManagerBase implements ProfilePartParser {
    protected final CollectionRef colRef;

    public ProfileNamespaceManagerBase(DataApiManager dataApiManager, DiskDataSource diskDataSource,
            CollectionRef colRef)
    {
        super(dataApiManager, diskDataSource);
        this.colRef = colRef;
    }

    protected ListF<DataRecord> getRecordsFromAllCollections(DataApiUserId uid) {
        return getRecords(uid, dbRef());
    }

    protected ListF<DataRecord> getRecords(DataApiUserId uid) {
        return getRecords(uid, colRef);
    }

    public Option<DataRecord> getRecord(DataApiUserId uid, String recordId) {
        return getRecord(uid, colRef.consRecordRef(recordId));
    }

    public Database getDatabase(DataApiUserId uid) {
        return getDatabase(uid, dbRef());
    }

    Database applyDeltaWithRetries(DataApiUserId uid, RecordChange change) {
        return applyDeltaWithRetries(uid, Cf.list(change));
    }

    protected Database applyDeltaWithRetries(DataApiUserId uid, ListF<RecordChange> changes) {
        return applyDeltaWithRetries(uid, new Delta(changes));
    }

    Database applyDeltaWithRetries(DataApiUserId uid, Delta delta) {
        return applyDeltaWithRetries(uid, dbRef(), delta);
    }

    protected <T> ListF<T> parseRecords(ListF<DataRecord> records, Function<DataRecord, T> mapper) {
        return records
                .filter(record -> record.getCollectionId().equals(colRef.collectionId))
                .map(mapper);
    }

    @Override
    public DatabaseRef dbRef() {
        return colRef.dbRef();
    }
}
