package ru.yandex.chemodan.app.dataapi.apps.profile;

import org.apache.commons.lang3.StringUtils;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.Tuple2;
import ru.yandex.chemodan.app.dataapi.api.data.field.DataField;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author tolmalev
 */
public abstract class ProfileRecordSupport extends DefaultObject {

    public abstract MapF<String, DataField> toDataMap();

    protected static DataField stringListToDataField(ListF<String> value) {
        return DataField.list(value.map(DataField::string));
    }

    protected static MapF<String, DataField> plusList(MapF<String, DataField> map, String field,
            ListF<String> value)
    {
        if (value.isNotEmpty()) {
            return map.plus1(field, stringListToDataField(value));
        }
        return map;
    }

    protected static MapF<String, DataField> plusStringO(MapF<String, DataField> map, String field,
            Option<String> value)
    {
        return plusO(map, field, value.map(DataField.stringF()));
    }

    protected static MapF<String, DataField> plusNonEmptyStringO(MapF<String, DataField> map, String field,
            Option<String> value)
    {
        if (StringUtils.isEmpty(value.getOrNull())) {
            value = Option.empty();
        }
        return plusStringO(map, field, value);
    }

    protected static MapF<String, DataField> plusIntegerO(MapF<String, DataField> map, String field,
            Option<? extends Number> value)
    {
        return plusO(map, field, value.map(v -> DataField.integer(v.longValue())));
    }

    protected static MapF<String, DataField> plusTimestampO(MapF<String, DataField> map,
            String field,
            Option<Instant> value)
    {
        return plusO(map, field, value.map(DataField.timestampF()));
    }

    private static MapF<String, DataField> plusO(MapF<String, DataField> map, String field,
            Option<DataField> value)
    {
        if (value.isPresent()) {
            return map.plus1(field, value.get());
        }
        return map;
    }

    protected static ListF<String> extractStringList(Option<DataField> fieldO) {
        if (!fieldO.isPresent()) {
            return Cf.list();
        }
        return fieldO.get().listValue().map(DataField.stringValueF());
    }

    protected MapF<String, DataField> addSubObject(MapF<String, DataField> data, String prefix,
            Option<? extends ProfileRecordSupport> subObject)
    {
        if (subObject.isPresent()) {
            return addSubObject(data, prefix, subObject.get());
        } else {
            return data;
        }
    }

    protected MapF<String, DataField> addSubObject(MapF<String, DataField> data, String prefix,
            ProfileRecordSupport subObject)
    {
        for (Tuple2<String, DataField> tuple2 : subObject.toDataMap().entries()) {
            data = data.plus1(prefix + tuple2._1, tuple2._2);
        }
        return data;
    }
}
