package ru.yandex.chemodan.app.dataapi.apps.profile;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.chemodan.app.dataapi.api.context.DatabaseAppContext;
import ru.yandex.chemodan.app.dataapi.api.data.record.CollectionRef;
import ru.yandex.chemodan.app.dataapi.api.db.Database;
import ru.yandex.chemodan.app.dataapi.api.db.ref.DatabaseRef;
import ru.yandex.chemodan.app.dataapi.api.db.ref.DatabaseRefSource;
import ru.yandex.chemodan.app.dataapi.api.db.ref.DatabaseRefs;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;

/**
 * @author tolmalev
 */
public class ProfileUtils {
    public static final DatabaseAppContext PROFILE_CTX = new DatabaseAppContext("profile");

    public static final DatabaseRef ADDRESSES_DB_REF = consDbRef("addresses");

    public static final CollectionRef ADDRESSES_COL_REF = ADDRESSES_DB_REF.consColRef("common_addresses");

    public static final DatabaseRef EXTRACTED_ADDRESSES_DB_REF = consDbRef("extracted_addresses");

    private static final DatabaseRef GEOPOINT_DB_REF = consDbRef("geopoints");

    public static final CollectionRef GEOPOINT_COL_REF = GEOPOINT_DB_REF.consColRefWithDbId();

    public static final DatabaseRef EVENTS_DB_REF = consDbRef("events");

    public static final CollectionRef FLIGHTS_COL_REF = EVENTS_DB_REF.consColRef("flights");

    static final DatabaseRef YATICKETS_DB_REF = consDbRef("yatickets");

    public static final CollectionRef YATICKETS_ORDERS_COL_REF = YATICKETS_DB_REF.consColRef("orders");

    static final DatabaseRefs DB_REFS = DatabaseRefs.cons(
            ADDRESSES_DB_REF,
            GEOPOINT_DB_REF,
            EVENTS_DB_REF,
            YATICKETS_DB_REF
    );

    public static String buildProfileDatabaseHandle(DataApiUserId uid, DatabaseRefSource refSrc) {
        if (!refSrc.isBoundTo(PROFILE_CTX)) {
            throw new IllegalArgumentException("Utility supposed to generate handles for profile apps");
        }

        return PROFILE_CTX.appName() + "." + uid.toString() + "." + refSrc.databaseId();
    }

    public static boolean isProfileDb(Database database) {
        return database.isBoundTo(PROFILE_CTX);
    }

    public static DatabaseRef parseDbRefFromHandle(String handle) {
        return PROFILE_CTX.consDbRef(parseDatabaseIdFromHandle(handle));
    }

    private static String parseDatabaseIdFromHandle(String handle) {
        return Cf.list(handle.split("\\.")).last();
    }

    private static DatabaseRef consDbRef(String databaseId) {
        return PROFILE_CTX.consDbRef(databaseId);
    }
}
