package ru.yandex.chemodan.app.dataapi.apps.profile.address;

import org.joda.time.Instant;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.data.field.DataField;
import ru.yandex.chemodan.app.dataapi.api.deltas.FieldChange;

/**
 * @author Denis Bakharev
 */
public class AddressChangeNormalizer extends AddressChangedEventHandler {
    @Override
    protected ListF<FieldChange> onAddressChanged(Option<Address> oldAddress, Address newAddress) {
        ListF<FieldChange> addressFieldChanges = Cf.arrayList();

        addressFieldChanges.addAll(createFieldChangeIfDateTimeIsEmpty(newAddress.getCreated(), Address.CREATED));
        addressFieldChanges.addAll(createFieldChangeIfDateTimeIsEmpty(newAddress.getModified(), Address.MODIFIED));
        addressFieldChanges.addAll(createFieldChangeIfDateTimeIsEmpty(newAddress.getLastUsed(), Address.LAST_USED));

        return addressFieldChanges;
    }

    private Option<FieldChange> createFieldChangeIfDateTimeIsEmpty(Option<Instant> dateTime, String fieldKey) {
        if (!dateTime.isPresent()) {
            FieldChange fieldChange = FieldChange.put(fieldKey, DataField.timestamp(Instant.now()));
            return Option.of(fieldChange);
        } else {
            return Option.empty();
        }
    }
}
