package ru.yandex.chemodan.app.dataapi.apps.profile.address;

import org.joda.time.DateTime;
import org.joda.time.DateTimeUtils;
import org.joda.time.Instant;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.app.dataapi.api.data.field.DataField;
import ru.yandex.chemodan.app.dataapi.api.deltas.FieldChange;
import ru.yandex.chemodan.app.dataapi.api.deltas.RecordChange;
import ru.yandex.chemodan.app.dataapi.api.deltas.RecordChangeType;
import ru.yandex.chemodan.app.dataapi.apps.profile.test.ProfileUnitTestBase;
import ru.yandex.misc.test.Assert;

/**
 * @author Denis Bakharev
 */
public class AddressChangeNormalizerTest extends ProfileUnitTestBase {
    @BeforeClass
    public static void timeStop() {
        DateTime now = DateTime.now();
        DateTimeUtils.setCurrentMillisProvider(now::getMillis);
    }

    @AfterClass
    public static void timeStart() {
        DateTimeUtils.setCurrentMillisSystem();
    }

    @Test
    public void databaseChanged_AddressWithoutModifiedField_SetModifiedDateToNow() {
        AddressChangeNormalizer normalizer = new AddressChangeNormalizer();

        ListF<RecordChange> changedRecords = normalizer.databaseChanged(createEventWithAddress(new Address("id")));

        Assert.assertEquals(1, changedRecords.length());
        Assert.assertForAll(changedRecords, rec -> rec.type == RecordChangeType.UPDATE);

        assertHaveAddressFieldChangedToNow(changedRecords, Address.CREATED);
        assertHaveAddressFieldChangedToNow(changedRecords, Address.MODIFIED);
        assertHaveAddressFieldChangedToNow(changedRecords, Address.LAST_USED);
    }

    private void assertHaveAddressFieldChangedToNow(ListF<RecordChange> changedRecords, String fieldKey) {
        FieldChange change = FieldChange.put(fieldKey, DataField.timestamp(Instant.now()));
        Assert.assertExists(changedRecords, rec -> rec.fieldChanges.exists(fieldChange -> fieldChange.equals(change)));
    }

}
