package ru.yandex.chemodan.app.dataapi.apps.profile.address;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.DatabaseChangedEventHandler;
import ru.yandex.chemodan.app.dataapi.api.data.record.DataRecord;
import ru.yandex.chemodan.app.dataapi.api.data.record.DataRecordId;
import ru.yandex.chemodan.app.dataapi.api.data.snapshot.PatchableSnapshot;
import ru.yandex.chemodan.app.dataapi.api.deltas.FieldChange;
import ru.yandex.chemodan.app.dataapi.api.deltas.RecordChange;
import ru.yandex.chemodan.app.dataapi.apps.profile.ProfileUtils;

/**
 * @author Denis Bakharev
 */
public abstract class AddressChangedEventHandler implements DatabaseChangedEventHandler {
    @Override
    public ListF<RecordChange> databaseChanged(PatchableSnapshot snapshot) {
        if (!AddressDataApiDao.isAddressDatabase(snapshot.database())) {
            return Cf.list();
        }

        ListF<DataRecord> records = snapshot.patchedRecords.iterator()
                .filter(AddressDataApiDao::isAddressRecord)
                .toList();

        ListF<RecordChange> recordChanges = Cf.arrayList();
        for (DataRecord newAddressRecord : records) {
            Address newAddress = Address.fromDataRecord(newAddressRecord);
            DataRecordId addressRecordId = ProfileUtils.ADDRESSES_COL_REF
                    .consRecordRef(newAddress.getAddressId().get())
                    .toRecordId(snapshot.database().dbHandle);

            Option<Address> oldAddress = snapshot.initialSnapshot.getRecordO(addressRecordId)
                    .map(Address::fromDataRecord);

            ListF<FieldChange> addressFieldChanges = onAddressChanged(oldAddress, newAddress);
            if (addressFieldChanges.isNotEmpty()) {
                RecordChange recordChange = RecordChange.update(ProfileUtils.ADDRESSES_COL_REF,
                        newAddress.getAddressId().get(),
                        addressFieldChanges);

                recordChanges.addAll(recordChange);
            }
        }
        return recordChanges;
    }

    abstract protected ListF<FieldChange> onAddressChanged(Option<Address> oldAddress, Address newAddress);

    @Override
    public int getOrder() {
        return NORMALIZATION_ORDER;
    }
}
