package ru.yandex.chemodan.app.dataapi.apps.profile.address;

import ru.yandex.chemodan.app.dataapi.api.DatabaseChangedEventAsyncHandler;
import ru.yandex.chemodan.app.dataapi.api.data.record.DataRecord;
import ru.yandex.chemodan.app.dataapi.api.deltas.DatabaseChange;
import ru.yandex.commune.bazinga.BazingaTaskManager;

/**
 * @author Denis Bakharev
 */
public class AddressChangesAsyncHandler implements DatabaseChangedEventAsyncHandler {
    private final BazingaTaskManager bazingaTaskManager;

    public AddressChangesAsyncHandler(BazingaTaskManager bazingaTaskManager) {
        this.bazingaTaskManager = bazingaTaskManager;
    }

    @Override
    public void databaseChanged(DatabaseChange event) {
        for (DataRecord dataRecord : event.getPatchedRecords()) {
            handle(event, dataRecord);
        }
    }

    public void handle(DatabaseChange event, DataRecord dataRecord) {
        if (!AddressDataApiDao.isAddressRecord(dataRecord)) {
            return;
        }

        Address address = Address.fromDataRecord(dataRecord);
        if (!address.getAddressLine().isPresent() || !address.getAddressLineShort().isPresent()) {
            bazingaTaskManager.schedule(new SetAddressLinesFromGeocoderTask(event.patchedDatabase().uid,
                    dataRecord.rev,
                    dataRecord.getRecordId()));
        }
    }
}
