package ru.yandex.chemodan.app.dataapi.apps.profile.address;


import org.junit.Test;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.data.record.DataRecord;
import ru.yandex.chemodan.app.dataapi.api.data.record.DataRecordId;
import ru.yandex.chemodan.app.dataapi.api.data.snapshot.Snapshot;
import ru.yandex.chemodan.app.dataapi.api.db.Database;
import ru.yandex.chemodan.app.dataapi.api.deltas.DatabaseChange;
import ru.yandex.chemodan.app.dataapi.api.deltas.Delta;
import ru.yandex.chemodan.app.dataapi.apps.profile.ProfileUtils;
import ru.yandex.chemodan.app.dataapi.apps.profile.test.ProfileUnitTestBase;
import ru.yandex.commune.bazinga.test.BazingaTaskManagerStub;
import ru.yandex.misc.test.Assert;

/**
 * @author Denis Bakharev
 */
public class AddressChangesListenerUnitTest extends ProfileUnitTestBase {
    private final AddressChangesAsyncHandler taskCreator;
    private final BazingaTaskManagerStub bazingaStub;
    private final Address address;

    public AddressChangesListenerUnitTest() {
        bazingaStub = new BazingaTaskManagerStub();
        taskCreator = new AddressChangesAsyncHandler(bazingaStub);
        address = new Address("recId");
    }

    @Test
    public void databaseChanged_WithoutBothAddressLines_ScheduleTask() {
        sendEvent(address);
        assertScheduleTask();
    }

    @Test
    public void databaseChanged_WithoutAddressLine_ScheduleTask() {
        address.setAddressLine(Option.of("addressLine"));
        sendEvent(address);
        assertScheduleTask();
    }

    @Test
    public void databaseChanged_WithoutAddressLineShort_ScheduleTask() {
        address.setAddressLineShort(Option.of("addressLineShort"));
        sendEvent(address);
        assertScheduleTask();
    }

    @Test
    public void databaseChanged_BothAddressLinesExists_DoesNotScheduleTask() {
        address.setAddressLine(Option.of("addressLine"));
        address.setAddressLineShort(Option.of("addressLineShort"));
        sendEvent(address);
        assertDoNothing();
    }

    private void sendEvent(Address address) {
        Delta delta = address.toFieldSet()
                .toInsertChange()
                .toDelta();
        Database database = getAddressDatabase();
        DataRecordId recordId = ProfileUtils.ADDRESSES_COL_REF
                .consRecordRef(address.getAddressId().get())
                .toRecordId(database.dbHandle);
        DataRecord addressDataRecord = new DataRecord(database.uid, recordId, database.rev, address.toDataMap());
        taskCreator.databaseChanged(
                new DatabaseChange(
                        Snapshot.empty(database),
                        new Snapshot(database, Cf.list(addressDataRecord)),
                        Cf.list(delta)
                )
        );
    }

    private void assertScheduleTask() {
        Assert.equals(1, bazingaStub.tasksWithParams.size());
        Assert.isInstance(bazingaStub.tasksWithParams.get(0), SetAddressLinesFromGeocoderTask.class);
    }

    private void assertDoNothing() {
        Assert.equals(0, bazingaStub.tasksWithParams.size());
    }
}
