package ru.yandex.chemodan.app.dataapi.apps.profile.address;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.app.dataapi.api.data.record.DataRecord;
import ru.yandex.chemodan.app.dataapi.api.db.Database;
import ru.yandex.chemodan.app.dataapi.api.deltas.FieldChange;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.chemodan.app.dataapi.apps.profile.FieldChangeUtils;
import ru.yandex.chemodan.app.dataapi.apps.profile.GenericProfileNamespaceManagerBase;
import ru.yandex.chemodan.app.dataapi.apps.profile.ProfileUtils;
import ru.yandex.chemodan.app.dataapi.apps.profile.full.Addresses;
import ru.yandex.chemodan.app.dataapi.apps.profile.full.FullUserProfileBuilder;
import ru.yandex.chemodan.app.dataapi.core.datasources.disk.DiskDataSource;
import ru.yandex.chemodan.app.dataapi.core.manager.DataApiManager;

/**
 * @author Denis Bakharev
 * @author akirakozov
 *         <p>
 *         simple CRUD operations(without any business logic) for Address entity
 *         </p>
 */
public class AddressDataApiDao extends GenericProfileNamespaceManagerBase<Address> {
    public AddressDataApiDao(DataApiManager dataApiManager, DiskDataSource diskDataSource) {
        super(dataApiManager, diskDataSource, ProfileUtils.ADDRESSES_COL_REF, Address::fromDataRecord);
    }

    @Override
    public void parse(FullUserProfileBuilder builder, ListF<DataRecord> records) {
        builder.setAddresses(new Addresses(parseRecords(records)));
    }

    public void updateAddress(DataApiUserId uid, Address address) {
        String addressId = address.getAddressId().get();
        Address sourceAddress = getEntityByUidAndId(uid, addressId);

        ListF<FieldChange> fieldChanges = FieldChangeUtils.createFieldChanges(sourceAddress, address);
        patchAddress(uid, addressId, new AddressPatch(fieldChanges));
    }

    public void setAddress(DataApiUserId uid, Address address) {
        setEntity(uid, address);
    }

    public Database insertAddress(DataApiUserId uid, Address address) {
        return insertEntity(uid, address);
    }

    public void patchAddress(DataApiUserId uid, String addressId, AddressPatch patch) {
        updateEntity(uid, addressId, patch.fieldChanges);
    }

    public static boolean isAddressDatabase(Database newDatabase) {
        return ProfileUtils.ADDRESSES_DB_REF.equals(newDatabase.dbRef());
    }

    public static boolean isAddressRecord(DataRecord dataRecord) {
        return ProfileUtils.ADDRESSES_COL_REF.collectionId.equals(dataRecord.getCollectionId());
    }
}
