package ru.yandex.chemodan.app.dataapi.apps.profile.address;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.deltas.FieldChange;
import ru.yandex.chemodan.app.dataapi.apps.profile.FieldChangeUtils;

/**
 * @author Denis Bakharev
 */
public class AddressLinesFromMinedAttributesRemover extends AddressChangedEventHandler {

    @Override
    protected ListF<FieldChange> onAddressChanged(Option<Address> oldAddress, Address newAddress) {
        Address newAddressClone = Address.fromData(newAddress.getAddressId().get(), newAddress.toDataMap());

        removeMinedAttributeIfEmpty(newAddress, newAddress.getAddressLine(), Address.ADDRESS_LINE);
        removeMinedAttributeIfEmpty(newAddress, newAddress.getAddressLineShort(), Address.ADDRESS_LINE_SHORT);

        ListF<FieldChange> fieldChanges = FieldChangeUtils.createFieldChanges(newAddressClone, newAddress);
        return fieldChanges;
    }

    private void removeMinedAttributeIfEmpty(Address address, Option<String> field, String minedAttribute) {
        if (!field.isPresent()) {
            address.getMinedAttributes().removeTs(minedAttribute);
        }
    }
}
