package ru.yandex.chemodan.app.dataapi.apps.profile.address;

import org.junit.Test;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.deltas.FieldChange;
import ru.yandex.chemodan.app.dataapi.api.deltas.RecordChange;
import ru.yandex.chemodan.app.dataapi.apps.profile.test.ProfileUnitTestBase;
import ru.yandex.misc.test.Assert;

/**
 * @author Denis Bakharev
 */
public class AddressLinesFromMinedAttributesRemoverUnitTest extends ProfileUnitTestBase {

    private final AddressLinesFromMinedAttributesRemover remover;
    private final Address address;

    public AddressLinesFromMinedAttributesRemoverUnitTest() {
        remover = new AddressLinesFromMinedAttributesRemover();
        address = new Address("id");
        address.getMinedAttributes().add(Address.TITLE);
        address.getMinedAttributes().add(Address.ADDRESS_LINE);
        address.getMinedAttributes().add(Address.ADDRESS_LINE_SHORT);
    }

    @Test
    public void databaseChanged_AddressWithoutBothAddressLines_RemovesBothAddressLinesFromMinedAttributes() {
        ListF<RecordChange> changedRecords = remover.databaseChanged(createEventWithAddress(address));

        assertSizeAndAddressId(changedRecords);
        Assert.equals(2, changedRecords.get(0).fieldChanges.size());
        Assert.assertContains(changedRecords.get(0).fieldChanges,
                              FieldChange.deleteListItem(Address.MINED_ATTRIBUTES, 1));
        Assert.assertContains(changedRecords.get(0).fieldChanges,
                              FieldChange.deleteListItem(Address.MINED_ATTRIBUTES, 1));
    }

    @Test
    public void databaseChanged_AddressWithoutAddressLineShort_RemovesAddressLineShortFromMinedAttributes() {
        address.setAddressLine(Option.of("AddressLine"));
        ListF<RecordChange> changedRecords = remover.databaseChanged(createEventWithAddress(address));

        assertSizeAndAddressId(changedRecords);
        Assert.equals(1, changedRecords.get(0).fieldChanges.size());
        Assert.assertContains(changedRecords.get(0).fieldChanges,
                              FieldChange.deleteListItem(Address.MINED_ATTRIBUTES, 2));
    }

    private void assertSizeAndAddressId(ListF<RecordChange> changedRecords) {
        Assert.equals(1, changedRecords.size());
        Assert.equals(changedRecords.get(0).recordId, address.getAddressId().get());
    }

}
